/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh.command.worktree;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCreateWorkTreeRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.GitWorkTreeBuilder;
import com.atlassian.bitbucket.scm.git.worktree.GitCheckoutType;
import com.atlassian.bitbucket.scm.git.worktree.GitWorkTree;
import com.atlassian.bitbucket.scm.git.worktree.GitWorkTreeCallback;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.stash.internal.scm.git.DefaultGitScmConfig;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.RpcGitWorkTreeClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.google.protobuf.ByteString;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.Duration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshWorkTreeBuilder
implements GitWorkTreeBuilder {
    private static final Logger log = LoggerFactory.getLogger(MeshWorkTreeBuilder.class);
    private static final Duration MAX_EXPIRY = Duration.ofSeconds(DefaultGitScmConfig.MAX_WORKTREE_EXPIRY_MINUTES);
    protected final GitScmConfig config;
    private final Set<Repository> alternates;
    private final I18nService i18nService;
    private final Repository repository;
    private final GitRequestHelper requestHelper;
    private final RpcGitWorkTreeClient workTreeClient;
    private GitCheckoutType checkoutType;
    private String commitId;
    private Duration expiry;

    public MeshWorkTreeBuilder(@Nonnull GitScmConfig config, @Nonnull I18nService i18nService, @Nonnull Repository repository, @Nonnull GitRequestHelper requestHelper, @Nonnull RpcGitWorkTreeClient workTreeClient) {
        this.config = Objects.requireNonNull(config, "config");
        this.i18nService = i18nService;
        this.repository = Objects.requireNonNull(repository, "repository");
        this.requestHelper = Objects.requireNonNull(requestHelper, "requestHelper");
        this.workTreeClient = Objects.requireNonNull(workTreeClient, "workTreeClient");
        this.alternates = new HashSet<Repository>();
        this.checkoutType = GitCheckoutType.NONE;
    }

    @Nonnull
    public GitWorkTreeBuilder alternate(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        this.alternates.add(repository);
        return this;
    }

    @Nonnull
    public GitWorkTreeBuilder checkoutType(@Nonnull GitCheckoutType type) {
        Objects.requireNonNull(type, "type");
        this.checkoutType = type;
        return this;
    }

    @Nonnull
    public GitWorkTreeBuilder commit(@Nullable String commitId) {
        this.commitId = commitId;
        return this;
    }

    public <T> T execute(@Nonnull GitWorkTreeCallback<T> callback) throws IOException {
        Objects.requireNonNull(callback, "callback");
        try (GitWorkTree workTree = this.createWorkTree();){
            Object object = callback.execute(workTree);
            return (T)object;
        }
    }

    @Nonnull
    public GitWorkTreeBuilder expiry(@Nullable Duration value) {
        this.expiry = value == null ? null : (MAX_EXPIRY.compareTo(value) < 0 ? MAX_EXPIRY : value);
        return this;
    }

    private GitWorkTree createWorkTree() {
        this.validateAlternates();
        RpcCreateWorkTreeRequest.Builder requestBuilder = RpcCreateWorkTreeRequest.newBuilder().setCommitish(ByteString.copyFromUtf8((String)StringUtils.defaultString((String)this.commitId))).setExpiry(this.getExpiry().getSeconds()).setCheckoutType(RpcUtils.toCheckoutType((GitCheckoutType)this.checkoutType));
        this.alternates.stream().map(arg_0 -> ((GitRequestHelper)this.requestHelper).toRepositoryId(arg_0)).forEach(arg_0 -> ((RpcCreateWorkTreeRequest.Builder)requestBuilder).addAlternates(arg_0));
        return this.workTreeClient.create(this.repository, requestBuilder);
    }

    private Duration getExpiry() {
        if (this.expiry == null) {
            return this.config.getWorkTreeExpiry();
        }
        return this.expiry;
    }

    private void validateAlternates() {
        if (this.alternates.isEmpty()) {
            return;
        }
        for (Repository alternate : this.alternates) {
            if (alternate.isRemote() == this.repository.isRemote()) continue;
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.scm.git.worktree.alternate.not.co-located", new Object[0]));
        }
        for (Repository alternate : this.alternates) {
            if (Objects.equals(alternate.getHierarchyId(), this.repository.getHierarchyId())) continue;
            log.warn("Attempting to create a worktree with one or more alternate repositories belonging to different hierarchies. This operation may fail and will not be allowed starting from Bitbucket 10");
            return;
        }
    }
}

