/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.migration;

import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
final class DefaultHooks {
    static final Set<String> DEFAULT_HOOK_HASHES;
    static final int DEFAULT_HOOK_MAXIMUM_LENGTH = 1024;
    private static final Logger log;

    private DefaultHooks() {
        throw new UnsupportedOperationException("Can not be initialised.");
    }

    @Nonnull
    static String hash(@Nonnull byte[] hook) {
        return DigestUtils.sha1Hex((byte[])hook);
    }

    static boolean isDefaultHook(@Nonnull Path hooksDir, @Nonnull Path hook) throws IOException {
        Objects.requireNonNull(hooksDir, "hooksDir");
        Objects.requireNonNull(hook, "hook");
        if (Files.isDirectory(hook, new LinkOption[0])) {
            throw new IllegalArgumentException("Given path is a directory: " + String.valueOf(hook));
        }
        if (Files.size(hook) > 1024L) {
            return false;
        }
        byte[] trimmedBytes = new String(Files.readAllBytes(hook), StandardCharsets.UTF_8).trim().getBytes(StandardCharsets.UTF_8);
        String hash = DefaultHooks.hash(trimmedBytes);
        return DEFAULT_HOOK_HASHES.contains(hash);
    }

    @Nonnull
    private static Set<String> loadHashes(@Nonnull String filename) {
        URL hashesFile = DefaultHooks.class.getResource(filename);
        try {
            if (hashesFile == null) {
                throw new IllegalArgumentException("Default hash with the given path not found: " + filename);
            }
            return ImmutableSet.copyOf((Collection)IOUtils.readLines((InputStream)hashesFile.openStream(), (Charset)StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.warn("Could not load default hashes for file: {}; will not be able to detect some default hooks.", (Object)filename, (Object)e);
            return Collections.emptySet();
        }
    }

    static {
        log = LoggerFactory.getLogger(DefaultHooks.class);
        DEFAULT_HOOK_HASHES = DefaultHooks.loadHashes("default-hook.hashes");
    }
}

