/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.migration;

import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.migration.Exporter;
import com.atlassian.bitbucket.migration.SequentialArchive;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.scm.git.migration.GitMigrationPaths;
import com.atlassian.stash.internal.scm.git.pull.GitPullRequestCache;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;

public class GitPullRequestExporter
implements Exporter {
    private final GitPullRequestCache pullRequestCache;

    public GitPullRequestExporter(GitPullRequestCache pullRequestCache) {
        this.pullRequestCache = pullRequestCache;
    }

    public void export(@Nonnull ExportContext exportContext, @Nonnull PullRequest pullRequest) {
        this.exportCaches(exportContext, pullRequest);
    }

    @Nonnull
    private static Path getArchiveBasePath(@Nonnull String repoExportId, long pullRequestId) {
        return GitMigrationPaths.PATH_REPOSITORIES.resolve(repoExportId).resolve(GitMigrationPaths.PATH_PULL_REQUESTS).resolve(Long.toString(pullRequestId));
    }

    private void exportCaches(@Nonnull ExportContext exportContext, @Nonnull PullRequest pullRequest) {
        Repository repository = pullRequest.getToRef().getRepository();
        String repoExportId = exportContext.getEntityMapping(StandardMigrationEntityType.REPOSITORY).getExportId((Object)repository.getId());
        exportContext.addEntriesAsArchive(GitPullRequestExporter.getArchiveBasePath(repoExportId, pullRequest.getId()).resolve(GitMigrationPaths.ARCHIVE_CACHES), sequentialArchive -> this.pullRequestCache.exportByPullRequest(pullRequest, (SequentialArchive)sequentialArchive), true);
    }
}

