/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.migration;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.migration.ArchiveSource;
import com.atlassian.bitbucket.migration.ImportContext;
import com.atlassian.bitbucket.migration.ImportException;
import com.atlassian.bitbucket.migration.Importer;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.stash.internal.scm.git.migration.GitMigrationPaths;
import com.atlassian.stash.internal.scm.git.pull.GitPullRequestCache;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitPullRequestImporter
implements Importer {
    private static final PathMatcher PATH_MATCHER_CACHES_ARCHIVE = path -> path.getNameCount() == 5 && path.startsWith(GitMigrationPaths.PATH_REPOSITORIES) && path.getName(2).equals(GitMigrationPaths.PATH_PULL_REQUESTS) && path.endsWith(GitMigrationPaths.ARCHIVE_CACHES);
    private static final Logger log = LoggerFactory.getLogger(GitPullRequestImporter.class);
    private final I18nService i18nService;
    private final GitPullRequestCache pullRequestCache;
    private final PullRequestService pullRequestService;

    public GitPullRequestImporter(I18nService i18nService, GitPullRequestCache pullRequestCache, PullRequestService pullRequestService) {
        this.i18nService = i18nService;
        this.pullRequestCache = pullRequestCache;
        this.pullRequestService = pullRequestService;
    }

    public void onArchiveEntry(@Nonnull ImportContext importContext, @Nonnull ArchiveSource archiveSource) {
        Objects.requireNonNull(importContext, "importContext");
        Objects.requireNonNull(archiveSource, "archiveSource");
        Path archiveSourcePath = archiveSource.getPath();
        if (PATH_MATCHER_CACHES_ARCHIVE.matches(archiveSourcePath)) {
            this.importCaches(importContext, archiveSource);
        } else {
            log.warn("Ignoring unexpected archive entry: {}", (Object)archiveSourcePath);
        }
    }

    private void importCaches(@Nonnull ImportContext importContext, @Nonnull ArchiveSource archiveSource) {
        long pullRequestId;
        Path archivePath = archiveSource.getPath();
        int repositoryId = (Integer)importContext.getEntityMapping(StandardMigrationEntityType.REPOSITORY).getLocalId(archivePath.getName(1).toString()).orElseThrow(() -> this.repositoryNotFound(archivePath));
        PullRequest pullRequest = this.pullRequestService.getById(repositoryId, pullRequestId = Long.parseLong(archivePath.getName(3).toString()));
        if (pullRequest == null) {
            importContext.addWarning(this.i18nService.createKeyedMessage("bitbucket.git.import.caches.pullrequestnotfound", new Object[]{repositoryId, pullRequestId}), null);
            return;
        }
        try {
            this.pullRequestCache.importForPullRequest(pullRequest, archiveSource);
        }
        catch (IOException e) {
            importContext.addWarning(this.i18nService.createKeyedMessage("bitbucket.git.import.caches.failed", new Object[]{repositoryId, pullRequestId}), (Object)pullRequest, (Throwable)e);
        }
    }

    private ImportException repositoryNotFound(Path path) {
        return new ImportException(this.i18nService.createKeyedMessage("bitbucket.git.import.failed.repositorynotfound", new Object[]{path}));
    }
}

