/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.migration;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.io.IoConsumer;
import com.atlassian.bitbucket.migration.EntityExportMapping;
import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.migration.ExportException;
import com.atlassian.bitbucket.migration.ExportSection;
import com.atlassian.bitbucket.migration.Exporter;
import com.atlassian.bitbucket.migration.SequentialArchive;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandTimeoutException;
import com.atlassian.bitbucket.util.FileUtils;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.PathMatchers;
import com.atlassian.stash.internal.migration.FileWalkerUtils;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.gc.GcPause;
import com.atlassian.stash.internal.scm.git.gc.GitGarbageTruck;
import com.atlassian.stash.internal.scm.git.migration.DefaultHooks;
import com.atlassian.stash.internal.scm.git.migration.GitMigrationPaths;
import com.atlassian.stash.internal.scm.git.transcode.TranscodeService;
import com.atlassian.stash.internal.scm.git.util.AlternatesUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.retry.ExceptionHandler;
import io.atlassian.fugue.retry.ExceptionHandlers;
import io.atlassian.fugue.retry.RetryFactory;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class GitRepositoryExporter
implements Exporter {
    public static final String PATH_REPOSITORY_CONFIG = "repository-config";
    private static final PathMatcher EXCLUDE_PACKED_REFS = path -> !path.endsWith("packed-refs");
    private static final PathMatcher EXCLUDE_REFS_LOGS = path -> !path.endsWith("logs");
    private static final PathMatcher EXCLUDE_STASH_REFS = path -> !path.endsWith("stash-refs");
    private static final int FILE_COPY_RETRIES = 10;
    private static final FileSystem FILE_SYSTEM = FileSystems.getDefault();
    private static final Path GIT_OBJECTS_PATH = Paths.get("objects", new String[0]);
    private static final Path GIT_OBJECTS_INFO_ALTERNATES_PATH = GIT_OBJECTS_PATH.resolve(Paths.get("info", "alternates"));
    private static final PathMatcher EXCLUDE_ALTERNATES_FILE = path -> !path.endsWith(GIT_OBJECTS_INFO_ALTERNATES_PATH);
    private static final Path GIT_OBJECTS_PACK_PATH = GIT_OBJECTS_PATH.resolve("pack");
    private static final Path GIT_OBJECTS_INFO_PACKS_PATH = GIT_OBJECTS_PATH.resolve(Paths.get("info", "packs"));
    private static final String PATH_SEP = File.separatorChar == '\\' ? "\\\\" : File.separator;
    private static final PathMatcher EXCLUDE_TRANSCODE_PL = PathMatchers.not((PathMatcher)FILE_SYSTEM.getPathMatcher("glob:{**/,}transcode.pl".replace("/", PATH_SEP)));
    private static final PathMatcher EXCLUDE_OBJECTS_INFO_AND_PACK_FILES = PathMatchers.not((PathMatcher)FILE_SYSTEM.getPathMatcher("glob:{**/,}objects/{info,pack" + "}".replace("/", PATH_SEP)));
    private static final PathMatcher EXCLUDE_HOOKS = PathMatchers.not((PathMatcher)FILE_SYSTEM.getPathMatcher("glob:{**/,}{hooks,hooks/*}".replace("/", PATH_SEP)));
    private static final PathMatcher EXCLUDE_OBJECTS = PathMatchers.not((PathMatcher)FILE_SYSTEM.getPathMatcher("glob:{**/,}objects" + "/*".replace("/", PATH_SEP)));
    private static final PathMatcher EXCLUDE_SAMPLES = PathMatchers.not((PathMatcher)FILE_SYSTEM.getPathMatcher("glob:{**/,}hooks/*.sample".replace("/", PATH_SEP)));
    private static final PathMatcher EXCLUDE_LOCK_FILES = PathMatchers.not((PathMatcher)FILE_SYSTEM.getPathMatcher("glob:{**/,}*.lock".replace("/", PATH_SEP)));
    private static final PathMatcher EXCLUDE_TMP_OBJ_FILES = PathMatchers.not((PathMatcher)FILE_SYSTEM.getPathMatcher("glob:{**/,}tmp_{obj,pack,bitmap,idx}_*".replace("/", PATH_SEP)));
    private static final PathMatcher EXCLUDE_INCOMING_OBJ_FILES = PathMatchers.not((PathMatcher)FILE_SYSTEM.getPathMatcher("glob:{**/,}incoming-*".replace("/", PATH_SEP)));
    private static final PathMatcher INCLUDE_REAL_OBJ_FILES = FILE_SYSTEM.getPathMatcher("glob:{**/,}*.{pack,bitmap,idx}".replace("/", PATH_SEP));
    private static final Logger log = LoggerFactory.getLogger(GitRepositoryExporter.class);
    private final GitScmConfig config;
    private final GitGarbageTruck garbageTruck;
    private final I18nService i18nService;
    private final TranscodeService transcodeService;

    public GitRepositoryExporter(GitScmConfig config, GitGarbageTruck garbageTruck, I18nService i18nService, TranscodeService transcodeService) {
        this.config = config;
        this.garbageTruck = garbageTruck;
        this.i18nService = i18nService;
        this.transcodeService = transcodeService;
    }

    public void export(@Nonnull ExportContext exportContext, @Nonnull Repository repository) {
        Objects.requireNonNull(exportContext, "exportContext");
        try (GcPause gcPause = this.garbageTruck.tryPauseGc(repository, this.config.getExportGcPauseTimeout());){
            if (gcPause == null) {
                log.info("[{}] Git GC lock could not be acquired, continuing without it.", (Object)repository);
            }
            this.doExport(exportContext, repository);
        }
        catch (CommandTimeoutException | IOException e) {
            log.warn("[{}] Failed to pause GC, continuing without it.", (Object)repository, (Object)e);
            this.doExport(exportContext, repository);
        }
    }

    @Nonnull
    private static PathMatcher filterRepositoryConfig(@Nonnull Path repoDir) {
        return p -> !p.startsWith(repoDir) || !Objects.equals(Paths.get(PATH_REPOSITORY_CONFIG, new String[0]), repoDir.relativize(p));
    }

    @Nonnull
    private static Path getArchiveBasePath(@Nonnull String repoExportId) {
        return GitMigrationPaths.PATH_REPOSITORIES.resolve(repoExportId);
    }

    private static void snapshotObjectPackFiles(@Nonnull Path repoDir, @Nonnull Path targetDirectory) throws IOException {
        Path sourceInfoPacksFile = repoDir.resolve(GIT_OBJECTS_INFO_PACKS_PATH);
        Path targetInfoPacksFile = targetDirectory.resolve(GIT_OBJECTS_INFO_PACKS_PATH);
        try {
            Files.createDirectories(targetInfoPacksFile.getParent(), new FileAttribute[0]);
            Files.copy(sourceInfoPacksFile, targetInfoPacksFile, new CopyOption[0]);
        }
        catch (FileAlreadyExistsException | NoSuchFileException e) {
            log.trace("Ignoring exception while copying info/packs file: {}", (Object)e.toString());
        }
        PathMatchers.CombinablePathMatcher filter = PathMatchers.either((PathMatcher)INCLUDE_REAL_OBJ_FILES).or((PathMatcher)PathMatchers.both((PathMatcher)EXCLUDE_LOCK_FILES).and(EXCLUDE_TMP_OBJ_FILES).and(EXCLUDE_INCOMING_OBJ_FILES));
        GitRepositoryExporter.snapshotPath(repoDir.resolve(GIT_OBJECTS_PACK_PATH), targetDirectory.resolve(GIT_OBJECTS_PACK_PATH), (PathMatcher)filter);
    }

    private static void snapshotPath(final @Nonnull Path sourcePath, @Nonnull Path targetPath, final @Nonnull PathMatcher filter) throws IOException {
        final IoConsumer fileOperation = file -> {
            Path relativizedFile = sourcePath.relativize((Path)file);
            if (!filter.matches((Path)file)) {
                log.trace("snapshotPath('{}'): Skipping file '{}' because it doesn't pass the filter.", (Object)sourcePath, (Object)relativizedFile);
                return;
            }
            Path target = targetPath.resolve(relativizedFile);
            if (!Files.exists(target, new LinkOption[0])) {
                log.trace("snapshotPath('{}'): Creating snapshot of file '{}'.", (Object)sourcePath, (Object)relativizedFile);
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                try {
                    Files.createLink(target, file);
                }
                catch (UnsupportedOperationException | FileSystemException e) {
                    log.trace("snapshotPath('{}'): Hard-linking file '{}' not supported - copying instead.", (Object)sourcePath, (Object)relativizedFile);
                    Files.copy(file, target, new CopyOption[0]);
                }
            } else {
                log.trace("snapshotPath('{}'): File '{}' already exists in destination.", (Object)sourcePath, (Object)relativizedFile);
            }
        };
        if (Files.isDirectory(sourcePath, new LinkOption[0])) {
            FileWalkerUtils.walkFileTreeWithRetry((Path)sourcePath, (Set)ImmutableSet.of((Object)((Object)FileVisitOption.FOLLOW_LINKS)), (int)Integer.MAX_VALUE, (FileVisitor)new SimpleFileVisitor<Path>(){

                @Override
                @Nonnull
                public FileVisitResult preVisitDirectory(@Nonnull Path dir, @Nonnull BasicFileAttributes attrs) {
                    if (!filter.matches(dir)) {
                        if (log.isTraceEnabled()) {
                            log.trace("snapshotPath('{}'): Skipping directory '{}' because it doesn't pass the filter.", (Object)sourcePath, (Object)sourcePath.relativize(dir));
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                @Nonnull
                public FileVisitResult visitFile(@Nonnull Path file, @Nonnull BasicFileAttributes attrs) throws IOException {
                    fileOperation.accept((Object)file);
                    return FileVisitResult.CONTINUE;
                }
            }, (int)10);
        } else {
            try {
                fileOperation.accept((Object)sourcePath);
            }
            catch (NoSuchFileException e) {
                log.debug("File '{}' disappeared before it could be hard-linked/copied - continuing anyway.", (Object)sourcePath, (Object)e);
            }
        }
    }

    private static void withContentsSection(@Nonnull ExportContext exportContext, @Nonnull String repoExportId, @Nonnull IoConsumer<ExportSection> sectionActions) throws UncheckedIOException {
        exportContext.addSectionIfAbsent(GitRepositoryExporter.getArchiveBasePath(repoExportId).resolve(GitMigrationPaths.SECTION_CONTENTS), exportSection -> {
            try {
                sectionActions.accept(exportSection);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private static void withTemporaryDirectory(@Nonnull Path repoDir, @Nonnull String exportId, @Nonnull IoConsumer<Path> operation) throws IOException {
        Path tempDirectory = Files.createTempDirectory(repoDir.getParent(), "export_tmp_" + exportId + "_", new FileAttribute[0]);
        Exception caughtException = null;
        try {
            operation.accept((Object)tempDirectory);
        }
        catch (IOException | RuntimeException e) {
            caughtException = e;
            throw e;
        }
        finally {
            try {
                RetryFactory.create(() -> {
                    try {
                        MoreFiles.deleteRecursively((Path)tempDirectory);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }, (int)5, (ExceptionHandler)ExceptionHandlers.ignoreExceptionHandler(), (long)500L).run();
            }
            catch (UncheckedIOException suppressed) {
                if (caughtException != null) {
                    caughtException.addSuppressed(suppressed.getCause());
                }
                log.warn("Failed to clean up temporary directory for export: {}", (Object)tempDirectory, (Object)suppressed.getCause());
            }
        }
    }

    private void addPathIfExists(Path destinationInBundle, Path sourceOnDisk, SequentialArchive sequentialArchive, int attempts) throws IOException {
        try {
            if (Files.exists(sourceOnDisk, new LinkOption[0])) {
                sequentialArchive.addPathFromDisk(destinationInBundle, sourceOnDisk, attempts);
            } else {
                log.trace("addPathIfExists('{}', '{}') skipped", (Object)destinationInBundle, (Object)sourceOnDisk);
            }
        }
        catch (NoSuchFileException e) {
            log.trace("addPathIfExists('{}', '{}') failed", new Object[]{destinationInBundle, sourceOnDisk, e});
        }
    }

    private void addPathIfExists(Path destinationInBundle, Path sourceOnDisk, SequentialArchive sequentialArchive) throws IOException {
        try {
            if (Files.exists(sourceOnDisk, new LinkOption[0])) {
                sequentialArchive.addPathFromDisk(destinationInBundle, sourceOnDisk, 1);
            } else {
                log.trace("addPathIfExists('{}', '{}') skipped", (Object)destinationInBundle, (Object)sourceOnDisk);
            }
        }
        catch (NoSuchFileException e) {
            log.trace("addPathIfExists('{}', '{}') failed", new Object[]{destinationInBundle, sourceOnDisk, e});
        }
    }

    private void doExport(@Nonnull ExportContext exportContext, @Nonnull Repository repository) {
        Path repoDir = this.config.getRepositoryDir(repository);
        String repoExportId = exportContext.getEntityMapping(StandardMigrationEntityType.REPOSITORY).getExportId((Object)repository.getId());
        try {
            GitRepositoryExporter.withTemporaryDirectory(repoDir, repoExportId, (IoConsumer<Path>)((IoConsumer)snapshotDirectory -> {
                Set<String> alternates = this.exportAlternatesRecursively(exportContext, repoDir);
                GitRepositoryExporter.snapshotObjectPackFiles(repoDir, snapshotDirectory);
                this.exportMetadata(exportContext, repoExportId, repoDir);
                this.exportHooks(exportContext, repoExportId, repoDir);
                GitRepositoryExporter.withContentsSection(exportContext, repoExportId, (IoConsumer<ExportSection>)((IoConsumer)section -> {
                    section.addEntriesAsArchive(GitMigrationPaths.ARCHIVE_OBJECTS_PATH, sequentialArchive -> {
                        PathMatchers.CombinablePathMatcher filter = PathMatchers.both((PathMatcher)EXCLUDE_LOCK_FILES).and(EXCLUDE_OBJECTS_INFO_AND_PACK_FILES).and(EXCLUDE_TMP_OBJ_FILES).and(EXCLUDE_INCOMING_OBJ_FILES);
                        sequentialArchive.addPathFromDisk(repoDir.resolve(GIT_OBJECTS_PATH), (PathMatcher)filter, 10);
                        GitRepositoryExporter.snapshotObjectPackFiles(repoDir, snapshotDirectory);
                        sequentialArchive.addPathFromDisk(snapshotDirectory.resolve(GIT_OBJECTS_PATH), 10);
                    }, false);
                    this.writeDependenciesFile((ExportSection)section, (Iterable<String>)alternates);
                }));
            }));
        }
        catch (IOException | UncheckedIOException e) {
            throw this.newExportException(repoDir, e instanceof UncheckedIOException ? ((UncheckedIOException)e).getCause() : e);
        }
        this.exportTranscodeSetting(exportContext, repoExportId, repository);
    }

    private Set<String> exportAlternatesRecursively(@Nonnull ExportContext exportContext, @Nonnull Path repoDir) {
        EntityExportMapping entityMapping = exportContext.getEntityMapping(StandardMigrationEntityType.REPOSITORY);
        Map<String, String> localAlternates = this.getLocalAlternates(repoDir, (EntityExportMapping<Integer>)entityMapping);
        localAlternates.forEach((exportId, alternatePath) -> this.exportObjectsAndAlternatesRecursively(exportContext, (String)exportId, Paths.get(alternatePath, new String[0]).getParent()));
        return localAlternates.keySet();
    }

    private void exportHooks(@Nonnull ExportContext exportContext, @Nonnull String repoExportId, @Nonnull Path repoDir) {
        exportContext.addEntriesAsArchive(GitRepositoryExporter.getArchiveBasePath(repoExportId).resolve(GitMigrationPaths.ARCHIVE_HOOKS), sequentialArchive -> {
            Path hooksDir = repoDir.resolve("hooks");
            sequentialArchive.addPathFromDisk(hooksDir, (PathMatcher)PathMatchers.both((PathMatcher)EXCLUDE_SAMPLES).and(this.filterDefaultHooks(hooksDir)));
        }, true);
    }

    private void exportMetadata(@Nonnull ExportContext exportContext, @Nonnull String repoExportId, @Nonnull Path repoDir) {
        PathMatchers.CombinablePathMatcher metadataPathFilter = PathMatchers.both((PathMatcher)EXCLUDE_LOCK_FILES).and(EXCLUDE_OBJECTS).and(EXCLUDE_PACKED_REFS).and(EXCLUDE_STASH_REFS).and(EXCLUDE_REFS_LOGS).and(EXCLUDE_HOOKS).and(EXCLUDE_TRANSCODE_PL).and(GitRepositoryExporter.filterRepositoryConfig(repoDir));
        exportContext.addEntriesAsArchive(GitRepositoryExporter.getArchiveBasePath(repoExportId).resolve(GitMigrationPaths.ARCHIVE_METADATA), arg_0 -> this.lambda$exportMetadata$13(repoDir, (PathMatcher)metadataPathFilter, arg_0), true);
    }

    private void exportObjectsAndAlternatesRecursively(@Nonnull ExportContext exportContext, @Nonnull String repoExportId, @Nonnull Path repoDir) {
        GitRepositoryExporter.withContentsSection(exportContext, repoExportId, (IoConsumer<ExportSection>)((IoConsumer)section -> {
            EntityExportMapping entityMapping = exportContext.getEntityMapping(StandardMigrationEntityType.REPOSITORY);
            Map<String, String> localAlternates = this.getLocalAlternates(repoDir, (EntityExportMapping<Integer>)entityMapping);
            localAlternates.forEach((exportId, alternatePath) -> this.exportObjectsAndAlternatesRecursively(exportContext, (String)exportId, Paths.get(alternatePath, new String[0]).getParent()));
            section.addEntriesAsArchive(GitMigrationPaths.ARCHIVE_OBJECTS_PATH, sequentialArchive -> sequentialArchive.addPathFromDisk(repoDir.resolve(GIT_OBJECTS_PATH), (PathMatcher)PathMatchers.either((PathMatcher)INCLUDE_REAL_OBJ_FILES).or((PathMatcher)PathMatchers.both((PathMatcher)EXCLUDE_LOCK_FILES).and(EXCLUDE_ALTERNATES_FILE).and(EXCLUDE_TMP_OBJ_FILES).and(EXCLUDE_INCOMING_OBJ_FILES)), 10), false);
            this.writeDependenciesFile((ExportSection)section, (Iterable<String>)localAlternates.keySet());
        }));
    }

    private void exportTranscodeSetting(ExportContext exportContext, String repoExportId, Repository repository) {
        if (this.transcodeService.isEnabled(repository)) {
            Path path = GitRepositoryExporter.getArchiveBasePath(repoExportId).resolve(GitMigrationPaths.PATH_TRANSCODE_ENABLED);
            exportContext.addEntry(path, ExportSection.emptyEntry(), false);
        }
    }

    @Nonnull
    private PathMatcher filterDefaultHooks(@Nonnull Path hooksDir) {
        return path -> {
            Objects.requireNonNull(path, "path");
            if (Files.isDirectory(path, new LinkOption[0])) {
                return true;
            }
            try {
                return !DefaultHooks.isDefaultHook(hooksDir, path);
            }
            catch (IOException e) {
                throw this.newExportException(hooksDir.getParent(), e);
            }
        };
    }

    @Nonnull
    private Map<String, String> getLocalAlternates(@Nonnull Path repoDir, @Nonnull EntityExportMapping<Integer> entityMapping) {
        if (!AlternatesUtils.hasAlternates(repoDir)) {
            return ImmutableMap.of();
        }
        Path reposDir = repoDir.getParent();
        LinkedHashMap<String, String> alternates = new LinkedHashMap<String, String>();
        try {
            for (String alternate : AlternatesUtils.getAlternates(repoDir)) {
                if (!FileUtils.isFileWithin((File)new File(alternate), (File)reposDir.toFile())) continue;
                String exportId = entityMapping.getExportId((Object)AlternatesUtils.getAlternateRepositoryId(alternate));
                alternates.put(exportId, alternate);
            }
        }
        catch (IOException e) {
            throw this.newExportException(repoDir, e);
        }
        return alternates;
    }

    private ExportException newExportException(@Nonnull Path repoDir, @Nonnull Exception cause) {
        return new ExportException(this.i18nService.createKeyedMessage("bitbucket.git.export.failed", new Object[]{repoDir}), (Throwable)cause);
    }

    private void writeDependenciesFile(@Nonnull ExportSection exportSection, @Nonnull Iterable<String> alternateExportIds) {
        if (!Iterables.isEmpty(alternateExportIds)) {
            String dependenciesFileContent = Joiner.on((String)"\n").join(alternateExportIds);
            exportSection.addEntry(GitMigrationPaths.ARCHIVE_DEPENDENCIES_PATH, outputStream -> outputStream.write(dependenciesFileContent.getBytes(StandardCharsets.UTF_8)), false);
        }
    }

    private /* synthetic */ void lambda$exportMetadata$13(Path repoDir, PathMatcher metadataPathFilter, SequentialArchive sequentialArchive) throws IOException {
        sequentialArchive.addPathFromDisk(repoDir, metadataPathFilter, 10);
        this.addPathIfExists(Paths.get("", new String[0]), repoDir.resolve("packed-refs"), sequentialArchive, 10);
        this.addPathIfExists(Paths.get("stash-refs", new String[0]), repoDir.resolve("stash-refs"), sequentialArchive);
        this.addPathIfExists(Paths.get("logs", new String[0]), repoDir.resolve("logs"), sequentialArchive);
    }
}

