/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.migration;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.migration.ArchiveSource;
import com.atlassian.bitbucket.migration.EntrySource;
import com.atlassian.bitbucket.migration.ImportContext;
import com.atlassian.bitbucket.migration.ImportException;
import com.atlassian.bitbucket.migration.Importer;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.repository.InternalRepositoryService;
import com.atlassian.stash.internal.scm.git.migration.GitMigrationPaths;
import com.atlassian.stash.internal.scm.git.transcode.TranscodeService;
import com.atlassian.stash.internal.server.InternalDataStore;
import com.atlassian.stash.internal.server.InternalStorageService;
import com.google.common.base.Joiner;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class GitRepositoryImporter
implements Importer {
    private static final String ATT_MISSING_REPOS_BASE_DIR_MAP = "missingReposBaseDirMap";
    private static final String ATT_MISSING_REPOS_DIR_MAP = "missingReposDirMap";
    private static final String ATT_MISSING_REPO_ALTERNATES_MAP = "missingRepoAlternatesMap";
    private static final String IMPORTED_HOOKS_DIR_NAME = "imported-hooks";
    private static final PathMatcher PATH_MATCHER_DEPENDENCIES_FILE = path -> path.endsWith(GitMigrationPaths.SECTION_CONTENTS.resolve(GitMigrationPaths.ARCHIVE_DEPENDENCIES_PATH));
    private static final PathMatcher PATH_MATCHER_HOOKS_ARCHIVE = path -> path.endsWith(GitMigrationPaths.ARCHIVE_HOOKS);
    private static final PathMatcher PATH_MATCHER_METADATA_ARCHIVE = path -> path.endsWith(GitMigrationPaths.ARCHIVE_METADATA);
    private static final PathMatcher PATH_MATCHER_OBJECTS_ARCHIVE = path -> path.endsWith(GitMigrationPaths.SECTION_CONTENTS.resolve(GitMigrationPaths.ARCHIVE_OBJECTS_PATH));
    private static final PathMatcher PATH_MATCHER_TRANSCODE_ENABLED = path -> path.endsWith(GitMigrationPaths.PATH_TRANSCODE_ENABLED);
    private static final Logger log = LoggerFactory.getLogger(GitRepositoryImporter.class);
    private final I18nService i18nService;
    private final InternalRepositoryService repositoryService;
    private final InternalStorageService storageService;
    private final TranscodeService transcodeService;

    public GitRepositoryImporter(I18nService i18nService, InternalRepositoryService repositoryService, InternalStorageService storageService, TranscodeService transcodeService) {
        this.i18nService = i18nService;
        this.repositoryService = repositoryService;
        this.storageService = storageService;
        this.transcodeService = transcodeService;
    }

    public void onArchiveEntry(@Nonnull ImportContext importContext, @Nonnull ArchiveSource archiveSource) {
        Objects.requireNonNull(importContext, "importContext");
        Objects.requireNonNull(archiveSource, "archiveSource");
        Path archiveSourcePath = archiveSource.getPath();
        if (PATH_MATCHER_METADATA_ARCHIVE.matches(archiveSourcePath)) {
            this.importGitMetadata(importContext, archiveSource);
        } else if (PATH_MATCHER_HOOKS_ARCHIVE.matches(archiveSourcePath)) {
            this.importGitHooks(importContext, archiveSource);
        } else if (PATH_MATCHER_OBJECTS_ARCHIVE.matches(archiveSourcePath)) {
            this.importGitObjects(importContext, archiveSource);
        } else {
            importContext.addWarning(this.i18nService.createKeyedMessage("bitbucket.git.import.failed.invalid.archive.entry", new Object[]{archiveSourcePath}), null);
        }
    }

    public void onEnd(final @Nonnull ImportContext importContext) {
        Map missingRepoBaseDirs = (Map)importContext.getAttributeMap().getOrDefault((Object)ATT_MISSING_REPOS_BASE_DIR_MAP, Collections.emptyMap());
        for (Path missingReposTempDir : missingRepoBaseDirs.values()) {
            final ArrayList directoryVisitErrors = new ArrayList();
            try {
                Files.walkFileTree(missingReposTempDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Objects.requireNonNull(dir, "dir");
                        if (exc != null) {
                            directoryVisitErrors.add(exc);
                        }
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Objects.requireNonNull(file, "file");
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        importContext.addWarning(GitRepositoryImporter.this.i18nService.createKeyedMessage("bitbucket.git.import.failed.delete.file", new Object[]{file.toString()}), (Object)exc);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                importContext.addWarning(this.i18nService.createKeyedMessage("bitbucket.git.import.failed.delete.temp.dir", new Object[]{missingReposTempDir}), (Object)e);
            }
            if (directoryVisitErrors.isEmpty()) continue;
            importContext.addWarning(this.i18nService.createKeyedMessage("bitbucket.git.import.failed.delete.temp.dir.errors", new Object[]{"\n- " + Joiner.on((String)"\n- ").join((Iterable)directoryVisitErrors.stream().map(Throwable::getMessage).collect(MoreCollectors.toImmutableList()))}), (Object)missingReposTempDir);
        }
    }

    public void onEntry(@Nonnull ImportContext importContext, @Nonnull EntrySource entrySource) {
        Objects.requireNonNull(importContext, "importContext");
        Objects.requireNonNull(entrySource, "entrySource");
        Path entrySourcePath = entrySource.getPath();
        if (PATH_MATCHER_DEPENDENCIES_FILE.matches(entrySourcePath)) {
            this.configureDependencies(importContext, entrySource);
        } else if (PATH_MATCHER_TRANSCODE_ENABLED.matches(entrySourcePath)) {
            this.enableTranscoding(importContext, entrySourcePath);
        } else {
            importContext.addWarning(this.i18nService.createKeyedMessage("bitbucket.git.import.failed.invalid.archive.entry", new Object[]{entrySourcePath}), null);
        }
    }

    @Nonnull
    private static Set<String> getAlternatesForMissingRepo(@Nonnull ImportContext importContext, @Nonnull String missingRepoExportId) {
        return ((Map)importContext.getAttributeMap().computeIfAbsent((Object)ATT_MISSING_REPO_ALTERNATES_MAP, x -> new HashMap())).computeIfAbsent(missingRepoExportId, y -> new LinkedHashSet());
    }

    @Nonnull
    private static String getExportId(@Nonnull Path entryPath) {
        return entryPath.getName(1).toString();
    }

    @Nonnull
    private static Optional<Integer> getLocalRepoId(@Nonnull ImportContext importContext, String dependencyExportId) {
        return importContext.getEntityMapping(StandardMigrationEntityType.REPOSITORY).getLocalId(dependencyExportId);
    }

    @Nonnull
    private static Map<String, Path> getMissingRepoBaseDirMap(@Nonnull ImportContext importContext) {
        return (Map)importContext.getAttributeMap().computeIfAbsent((Object)ATT_MISSING_REPOS_BASE_DIR_MAP, ignored -> new HashMap());
    }

    @Nonnull
    private static Map<String, Path> getMissingRepoTempDirsMap(@Nonnull ImportContext importContext) {
        return (Map)importContext.getAttributeMap().computeIfAbsent((Object)ATT_MISSING_REPOS_DIR_MAP, ignored -> new HashMap());
    }

    private void configureDependencies(@Nonnull ImportContext importContext, @Nonnull EntrySource dependenciesSource) {
        try {
            dependenciesSource.read(inputStream -> {
                List dependencies = IOUtils.readLines((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                Path dependenciesSourcePath = dependenciesSource.getPath();
                String exportId = dependenciesSourcePath.getName(1).toString();
                Optional<Integer> localId = GitRepositoryImporter.getLocalRepoId(importContext, exportId);
                if (localId.isPresent()) {
                    this.configureDependenciesForExistingRepo(importContext, dependenciesSourcePath, dependencies, localId.get());
                } else {
                    this.configureDependenciesForMissingRepo(importContext, dependenciesSourcePath, dependencies, exportId);
                }
            });
        }
        catch (IOException e) {
            throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.git.import.failed", new Object[]{dependenciesSource.getPath()}), (Throwable)e);
        }
    }

    private void configureDependenciesForExistingRepo(@Nonnull ImportContext importContext, @Nonnull Path dependenciesSourcePath, @Nonnull List<String> dependencies, int repoLocalId) throws IOException {
        Repository repo = this.getRepositoryOrFail(repoLocalId);
        Path alternatesFilePath = this.storageService.getRepositoryDir(repo).resolve(Paths.get("objects", "info", "alternates"));
        Files.createDirectories(alternatesFilePath.getParent(), new FileAttribute[0]);
        ArrayList alternates = new ArrayList();
        dependencies.forEach(dependencyExportId -> {
            Optional<Integer> dependencyLocalId = GitRepositoryImporter.getLocalRepoId(importContext, dependencyExportId);
            if (dependencyLocalId.isPresent()) {
                Repository dependency = this.getRepositoryOrFail(dependencyLocalId.get());
                alternates.add(this.storageService.getRepositoryDir(dependency).resolve("objects").toAbsolutePath().toString());
            } else {
                this.linkMissingRepoObjects(this.getMissingRepoTempDirPathOrFail(importContext, dependenciesSourcePath, (String)dependencyExportId), this.storageService.getRepositoryDir(repo).resolve("objects"));
                alternates.addAll(GitRepositoryImporter.getAlternatesForMissingRepo(importContext, dependencyExportId));
            }
        });
        if (!alternates.isEmpty()) {
            Files.write(alternatesFilePath, String.join((CharSequence)"\n", alternates).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    private void configureDependenciesForMissingRepo(@Nonnull ImportContext importContext, @Nonnull Path dependenciesSourcePath, @Nonnull List<String> dependencies, @Nonnull String missingRepoExportId) {
        dependencies.forEach(dependencyExportId -> {
            Optional<Integer> dependencyLocalId = GitRepositoryImporter.getLocalRepoId(importContext, dependencyExportId);
            if (dependencyLocalId.isPresent()) {
                Repository alternate = this.getRepositoryOrFail(dependencyLocalId.get());
                GitRepositoryImporter.getAlternatesForMissingRepo(importContext, missingRepoExportId).add(this.storageService.getRepositoryDir(alternate).resolve("objects").toAbsolutePath().toString());
            } else {
                Path missingForkTempDirPath = this.getMissingRepoTempDirPathOrFail(importContext, dependenciesSourcePath, missingRepoExportId);
                Path missingOriginTempDirPath = this.getMissingRepoTempDirPathOrFail(importContext, dependenciesSourcePath, (String)dependencyExportId);
                this.linkMissingRepoObjects(missingOriginTempDirPath, missingForkTempDirPath);
                GitRepositoryImporter.getAlternatesForMissingRepo(importContext, missingRepoExportId).addAll(GitRepositoryImporter.getAlternatesForMissingRepo(importContext, dependencyExportId));
            }
        });
    }

    @Nonnull
    private Path createTempDirectoryForMissingRepo(@Nonnull ImportContext importContext, @Nonnull ArchiveSource archiveSource) {
        Path storeDataDir;
        String storeId;
        Optional<InternalDataStore> dataStore = this.findDataStore(importContext, archiveSource);
        if (dataStore.isPresent()) {
            storeId = dataStore.get().getUuid();
            storeDataDir = dataStore.get().getDir();
        } else {
            storeId = "sharedHome";
            storeDataDir = this.storageService.getDataDir();
        }
        Path entryPath = archiveSource.getPath();
        String exportId = GitRepositoryImporter.getExportId(archiveSource.getPath());
        Path baseDirForMissingRepos = GitRepositoryImporter.getMissingRepoBaseDirMap(importContext).computeIfAbsent(storeId, ignored -> {
            try {
                Path importDir = MoreFiles.mkdir((Path)MoreFiles.resolve((Path)storeDataDir, (String)"migration", (String[])new String[]{"import"}));
                return Files.createTempDirectory(importDir, "missingRepos_", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.git.import.failed", new Object[]{entryPath}), (Throwable)e);
            }
        });
        return GitRepositoryImporter.getMissingRepoTempDirsMap(importContext).computeIfAbsent(exportId, ignored -> {
            try {
                return Files.createTempDirectory(baseDirForMissingRepos, exportId + "_", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.git.import.failed", new Object[]{entryPath}), (Throwable)e);
            }
        });
    }

    private void enableTranscoding(@Nonnull ImportContext importContext, @Nonnull Path entrySourcePath) {
        String exportId = entrySourcePath.getName(1).toString();
        Repository repository = this.getRepositoryOrFail(GitRepositoryImporter.getLocalRepoId(importContext, exportId).orElseThrow(this.repoNotFound(entrySourcePath)));
        this.transcodeService.setEnabled(repository, true);
    }

    private void extractArchiveToDisk(@Nonnull ArchiveSource archiveSource, @Nonnull Path pathOnDisk) {
        this.extractArchiveToDisk(archiveSource, pathOnDisk, null);
    }

    private void extractArchiveToDisk(@Nonnull ArchiveSource archiveSource, @Nonnull Path pathOnDisk, @Nullable Predicate<String> filter) {
        try {
            if (filter == null) {
                archiveSource.extractToDisk(pathOnDisk);
            } else {
                archiveSource.extractToDisk(pathOnDisk, filter);
            }
        }
        catch (IOException e) {
            throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.git.import.failed", new Object[]{archiveSource.getPath()}), (Throwable)e);
        }
    }

    private Optional<InternalDataStore> findDataStore(@Nonnull ImportContext importContext, @Nonnull ArchiveSource archiveSource) {
        String currentHierarchyId = (String)importContext.getCurrentHierarchyId().orElseThrow(() -> new ImportException(this.i18nService.createKeyedMessage("bitbucket.git.import.failed.hierarchynotfound", new Object[]{archiveSource.getPath()})));
        Page page = this.repositoryService.findByHierarchyId(currentHierarchyId, PageUtils.newRequest((int)0, (int)1));
        if (page.getSize() == 0) {
            log.warn("Unable to find a repository with the given hierarchy ID: " + currentHierarchyId);
            throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.git.import.failed.repositorywithhierarchynotfound", new Object[]{currentHierarchyId, archiveSource.getPath()}));
        }
        return InternalConverter.convertToInternalRepository((Repository)((Repository)page.getValues().iterator().next())).getDataStore();
    }

    private Path getMissingRepoTempDirPathOrFail(@Nonnull ImportContext importContext, @Nonnull Path entrySourcePath, @Nonnull String missingRepoExportId) {
        Path dependencyTempDirPath = GitRepositoryImporter.getMissingRepoTempDirsMap(importContext).get(missingRepoExportId);
        if (dependencyTempDirPath == null) {
            throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.git.import.failed.missing.fork.origin", new Object[]{entrySourcePath}));
        }
        return dependencyTempDirPath;
    }

    private Path getRepoPathOnDisk(@Nonnull ImportContext importContext, @Nonnull ArchiveSource archiveSource) {
        String exportId = GitRepositoryImporter.getExportId(archiveSource.getPath());
        int repoId = GitRepositoryImporter.getLocalRepoId(importContext, exportId).orElseThrow(this.repoNotFound(archiveSource.getPath()));
        Repository repository = this.getRepositoryOrFail(repoId);
        return this.storageService.getRepositoryDir(repository);
    }

    @Nonnull
    private Repository getRepositoryOrFail(int repoId) {
        Repository repo = this.repositoryService.getById(repoId);
        if (repo == null) {
            throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.git.import.failed.repositorynotfound", new Object[]{repoId}));
        }
        return repo;
    }

    private void importGitHooks(@Nonnull ImportContext importContext, @Nonnull ArchiveSource archiveSource) {
        Path repoDir = this.getRepoPathOnDisk(importContext, archiveSource);
        Path hooksDirectory = repoDir.resolve(IMPORTED_HOOKS_DIR_NAME);
        this.extractArchiveToDisk(archiveSource, hooksDirectory);
        if (Files.exists(hooksDirectory, new LinkOption[0])) {
            importContext.addWarning(this.i18nService.createKeyedMessage("bitbucket.git.import.custom.hooks.stored.in.dir", new Object[]{hooksDirectory}), null);
        }
    }

    private void importGitMetadata(@Nonnull ImportContext importContext, @Nonnull ArchiveSource archiveSource) {
        Path repoDir = this.getRepoPathOnDisk(importContext, archiveSource);
        this.extractArchiveToDisk(archiveSource, repoDir, path -> {
            if (path.startsWith("hooks")) {
                importContext.addWarning(this.i18nService.createKeyedMessage("bitbucket.git.import.custom.hook.skipped", new Object[]{repoDir.resolve((String)path)}), null);
                return false;
            }
            return true;
        });
    }

    private void importGitObjects(@Nonnull ImportContext importContext, @Nonnull ArchiveSource archiveSource) {
        String exportId = GitRepositoryImporter.getExportId(archiveSource.getPath());
        Optional<Integer> localId = GitRepositoryImporter.getLocalRepoId(importContext, exportId);
        if (localId.isPresent()) {
            Repository repository = this.getRepositoryOrFail(localId.get());
            this.extractArchiveToDisk(archiveSource, this.storageService.getRepositoryDir(repository).resolve("objects"));
        } else {
            Path tempDirPath = this.createTempDirectoryForMissingRepo(importContext, archiveSource);
            this.extractArchiveToDisk(archiveSource, tempDirPath);
        }
    }

    private void linkMissingRepoObjects(final @Nonnull Path missingOriginTempDirPath, final @Nonnull Path targetObjectsDirPath) {
        try {
            Files.walkFileTree(missingOriginTempDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path relativeFilePath = missingOriginTempDirPath.relativize(file);
                    if (relativeFilePath.startsWith("info")) {
                        return FileVisitResult.CONTINUE;
                    }
                    Path targetFile = targetObjectsDirPath.resolve(relativeFilePath);
                    Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                    try {
                        try {
                            Files.createLink(targetFile, file);
                        }
                        catch (UnsupportedOperationException | FileSystemException linking) {
                            Files.copy(file, targetFile, new CopyOption[0]);
                        }
                    }
                    catch (FileAlreadyExistsException e) {
                        log.info("File '{}' already exists, skipping.", (Object)targetFile, (Object)(log.isDebugEnabled() ? e : null));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.git.import.failed", new Object[]{targetObjectsDirPath.getParent()}), (Throwable)e);
        }
    }

    private Supplier<ImportException> repoNotFound(Path path) {
        return () -> new ImportException(this.i18nService.createKeyedMessage("bitbucket.git.import.failed.repositorynotfound", new Object[]{path}));
    }
}

