/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.porcelain;

import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.stash.internal.scm.git.porcelain.TimedRequest;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public abstract class AbstractTimedRequest
implements TimedRequest {
    private long executionTimeout;
    private long idleTimeout;

    protected AbstractTimedRequest(AbstractBuilder<?, ?> builder) {
        this.executionTimeout = builder.executionTimeout;
        this.idleTimeout = builder.idleTimeout;
    }

    @Override
    public <T> T configureAndCall(@Nonnull Command<T> command) {
        command.setExecutionTimeout(this.executionTimeout);
        command.setIdleTimeout(this.idleTimeout);
        return (T)command.call();
    }

    @Override
    public long getExecutionTimeout() {
        return this.executionTimeout;
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setExecutionTimeout(long executionTimeout) {
        this.executionTimeout = executionTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B, R>, R extends AbstractTimedRequest>
    extends BuilderSupport {
        private long executionTimeout;
        private long idleTimeout;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(@Nonnull AbstractTimedRequest request) {
            this.executionTimeout = Objects.requireNonNull(request, "request").getExecutionTimeout();
            this.idleTimeout = request.getIdleTimeout();
        }

        @Nonnull
        public abstract R build();

        @Nonnull
        public B executionTimeout(long value) {
            this.executionTimeout = value;
            return this.self();
        }

        @Nonnull
        public B idleTimeout(long value) {
            this.idleTimeout = value;
            return this.self();
        }

        @Nonnull
        public B timeout(long value) {
            this.executionTimeout = this.idleTimeout = value;
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

