/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol;

import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class RepositoryPath {
    private final String projectKey;
    private final String repoSlug;

    public RepositoryPath(@Nonnull String projectKey, @Nonnull String repoSlug) {
        this.projectKey = Objects.requireNonNull(projectKey, "projectKey");
        this.repoSlug = Objects.requireNonNull(repoSlug, "repoSlug");
    }

    @Nonnull
    public String getProjectKey() {
        return this.projectKey;
    }

    @Nonnull
    public String getRepositorySlug() {
        return this.repoSlug;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryPath that = (RepositoryPath)o;
        return Objects.equals(this.projectKey, that.projectKey) && Objects.equals(this.repoSlug, that.repoSlug);
    }

    public int hashCode() {
        return Objects.hash(this.projectKey, this.repoSlug);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("projectKey", (Object)this.projectKey).add("repoSlug", (Object)this.repoSlug).toString();
    }
}

