/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.http;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryMovedException;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.scm.AuthenticationState;
import com.atlassian.bitbucket.scm.git.protocol.http.GitHttpScmRequestHandler;
import com.atlassian.bitbucket.scm.http.HttpRequestDetails;
import com.atlassian.bitbucket.scm.http.HttpScmRequest;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.protocol.http.GitHttpErrorHelper;
import com.atlassian.stash.internal.scm.git.protocol.http.PathInfo;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGitHttpScmRequestHandler
implements GitHttpScmRequestHandler {
    private static final String GIT_RECEIVE_PACK = "git-receive-pack";
    private static final String GIT_UPLOAD_PACK = "git-upload-pack";
    protected final I18nService i18nService;
    protected final GitHttpErrorHelper gitHttpErrorHelper;
    protected final Logger log;
    private final AuthenticationContext authenticationContext;
    private final GitScmConfig config;
    private final RepositorySupplier repositorySupplier;
    private final RequestManager requestManager;

    protected AbstractGitHttpScmRequestHandler(AuthenticationContext authenticationContext, GitScmConfig config, GitHttpErrorHelper gitHttpErrorHelper, I18nService i18nService, RepositorySupplier repositorySupplier, RequestManager requestManager) {
        this.authenticationContext = authenticationContext;
        this.config = config;
        this.gitHttpErrorHelper = gitHttpErrorHelper;
        this.i18nService = i18nService;
        this.repositorySupplier = repositorySupplier;
        this.requestManager = requestManager;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @Nonnull
    public Optional<HttpScmRequest> create(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) {
        int protocolVersion = this.config.parseProtocolVersion(request.getHeader("Git-Protocol"));
        RequestType requestType = this.getRequestType(HttpRequestDetails.ofServletRequest((HttpServletRequest)request)).orElse(null);
        if (requestType == null) {
            return Optional.empty();
        }
        return this.create(request, requestType, response, protocolVersion);
    }

    public void sendAuthenticationError(@Nonnull AuthenticationState state, @Nonnull String summary, @Nonnull String detailMessage, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws IOException {
        this.gitHttpErrorHelper.sendAuthenticationError(request, response, state, summary, detailMessage);
    }

    public void sendError(@Nonnull String summary, @Nonnull String detailMessage, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws IOException {
        this.gitHttpErrorHelper.sendError(request, response, summary, detailMessage);
    }

    public boolean supports(@Nonnull HttpRequestDetails requestDetails) {
        return this.getRequestType(requestDetails).isPresent();
    }

    protected Optional<HttpScmRequest> create(HttpServletRequest request, RequestType requestType, HttpServletResponse response, int protocolVersion) {
        RequestContext requestContext = this.requestManager.getRequestContext();
        Repository repository = this.getRepositoryOrThrow(request, requestType);
        return Optional.of(this.chooseHandler(requestType, requestContext, repository, request, response, protocolVersion));
    }

    @Nonnull
    protected abstract HttpScmRequest chooseHandler(RequestType var1, RequestContext var2, Repository var3, HttpServletRequest var4, HttpServletResponse var5, int var6);

    protected Repository getRepositoryOrThrow(HttpServletRequest request, RequestType requestType) {
        if (requestType.isWrite() && !this.authenticationContext.isAuthenticated()) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.scm.not.authenticated", new Object[0]));
        }
        return PathInfo.parse(() -> ((HttpServletRequest)request).getPathInfo()).flatMap(PathInfo::getRepositoryPath).map(path -> {
            try {
                return this.repositorySupplier.getBySlug(path.getProjectKey(), path.getRepositorySlug());
            }
            catch (RepositoryMovedException e) {
                return e.getRepository();
            }
        }).orElseThrow(() -> new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.scm.no.such.repository.detail", new Object[0]), null));
    }

    private static boolean isGet(HttpRequestDetails request) {
        return "GET".equals(request.getMethod());
    }

    private static boolean isPost(HttpRequestDetails request) {
        return "POST".equals(request.getMethod());
    }

    private Optional<RequestType> getRequestType(HttpRequestDetails request) {
        String service = request.getParameter("service");
        if (GIT_RECEIVE_PACK.equals(service)) {
            return Optional.of(RequestType.OTHER_WRITE);
        }
        if (GIT_UPLOAD_PACK.equals(service)) {
            return Optional.of(RequestType.OTHER_READ);
        }
        return PathInfo.parse(() -> ((HttpRequestDetails)request).getPathInfo()).map(info -> {
            if (AbstractGitHttpScmRequestHandler.isPost(request)) {
                if (info.isReceive()) {
                    return RequestType.RECEIVE_PACK;
                }
                if (info.isUpload()) {
                    return RequestType.UPLOAD_PACK;
                }
            } else if (AbstractGitHttpScmRequestHandler.isGet(request) && info.isDumb()) {
                this.log.debug("It looks like we've received a 'dumb' protocol git request. service={}, pathInfo={}", (Object)service, (Object)request.getPathInfo());
            }
            return null;
        });
    }

    protected static enum RequestType {
        OTHER_WRITE(true),
        OTHER_READ(false),
        RECEIVE_PACK(true),
        UPLOAD_PACK(false);

        private final boolean write;

        private RequestType(boolean write) {
            this.write = write;
        }

        public boolean isWrite() {
            return this.write;
        }
    }
}

