/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.http;

import com.atlassian.bitbucket.ResourceBusyException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.process.CompositeNioStdioHandler;
import com.atlassian.bitbucket.dmz.process.NioStdinHandler;
import com.atlassian.bitbucket.dmz.process.NioStdioHandler;
import com.atlassian.bitbucket.dmz.process.NioStdoutHandler;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCgiEnvironment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitTimeouts;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHttpBackendRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryOfflineException;
import com.atlassian.bitbucket.repository.RepositoryReadOnlyException;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.http.HttpScmRequest;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.hosting.HostingResult;
import com.atlassian.stash.internal.scm.git.mesh.RpcHostingClient;
import com.atlassian.stash.internal.scm.git.protocol.http.CgiStdinHandler;
import com.atlassian.stash.internal.scm.git.protocol.http.CgiStdoutHandler;
import com.atlassian.stash.internal.scm.git.protocol.http.GitHttpErrorHelper;
import com.atlassian.stash.internal.scm.git.protocol.http.GitSmartExitHandler;
import com.atlassian.stash.internal.scm.git.protocol.http.PathInfo;
import com.atlassian.util.contentcache.CacheResult;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractRpcHttpScmRequest
implements HttpScmRequest {
    private static final int DEFAULT_HTTP_HOSTING_BUFFER_SIZE = 8192;
    private static final int MINIMUM_HTTP_HOSTING_BUFFER_SIZE = 1024;
    private static final String PROP_HTTP_HOSTING_BUFFER_SIZE = "hosting.http.buffersize";
    protected final int bufferSize;
    protected final EventPublisher eventPublisher;
    protected final GitHttpErrorHelper gitHttpErrorHelper;
    protected final Logger log;
    protected final Repository repository;
    protected final HttpServletRequest request;
    protected final RequestContext requestContext;
    protected final HttpServletResponse response;
    protected GitSmartExitHandler exitHandler;
    private final AuthenticationContext authenticationContext;
    private final GitScmConfig config;
    private final RpcHostingClient hostingClient;
    private final I18nService i18nService;
    private final RequestManager requestManager;

    AbstractRpcHttpScmRequest(AuthenticationContext authenticationContext, GitScmConfig config, EventPublisher eventPublisher, GitHttpErrorHelper gitHttpErrorHelper, RpcHostingClient hostingClient, I18nService i18nService, Repository repository, HttpServletRequest request, RequestContext requestContext, RequestManager requestManager, HttpServletResponse response) {
        this.authenticationContext = authenticationContext;
        this.config = config;
        this.eventPublisher = eventPublisher;
        this.gitHttpErrorHelper = gitHttpErrorHelper;
        this.hostingClient = hostingClient;
        this.i18nService = i18nService;
        this.request = request;
        this.requestContext = requestContext;
        this.response = response;
        this.requestManager = requestManager;
        this.repository = repository;
        this.bufferSize = Math.max(config.getProperty(PROP_HTTP_HOSTING_BUFFER_SIZE, 8192), 1024);
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public void handleRequest() throws IOException {
        this.exitHandler = new GitSmartExitHandler(this.i18nService, this.repository, this.request, this.response, this.isWrite()){

            @Override
            public void onExit(@Nonnull String command, int exitCode, String stdErr, Throwable thrown) {
                if (thrown instanceof RepositoryOfflineException || thrown instanceof RepositoryReadOnlyException || thrown instanceof ResourceBusyException) {
                    throw (RuntimeException)thrown;
                }
                super.onExit(command, exitCode, stdErr, thrown);
            }

            @Override
            protected void onSuccess() {
                if (AbstractRpcHttpScmRequest.this.isOperationComplete()) {
                    AbstractRpcHttpScmRequest.this.onSuccess();
                }
            }
        };
        RpcHttpBackendRequest.Builder builder = RpcHttpBackendRequest.newBuilder().setCgiEnvironment(this.buildCgiEnvironment()).setTimeouts(this.getTimeouts());
        String protocol = this.request.getHeader("Git-Protocol");
        if (StringUtils.isNotBlank((CharSequence)protocol)) {
            builder.setProtocolHeader(protocol);
        }
        HostingResult result = this.hostingClient.httpBackend(this.repository, builder, this.createStdioHandler(), (CommandExitHandler)this.exitHandler);
        RequestContext requestContext = this.requestManager.getRequestContext();
        if (requestContext != null) {
            this.getLabels(result).forEach(arg_0 -> ((RequestContext)requestContext).addLabel(arg_0));
        }
    }

    public boolean isAsyncSupported() {
        return true;
    }

    public boolean isWrite() {
        return false;
    }

    public void sendError(@Nonnull String summary, @Nonnull String detailMessage) throws IOException {
        this.gitHttpErrorHelper.sendError(this.request, this.response, summary, detailMessage);
    }

    @Nonnull
    protected List<String> getLabels(HostingResult result) {
        ImmutableList.Builder labels = new ImmutableList.Builder();
        if (result != null) {
            Integer protocolVersion;
            String filter;
            CacheResult cacheResult = result.getCacheResult();
            if (cacheResult != null) {
                labels.add((Object)cacheResult.toString());
            }
            if ((filter = result.getFilter()) != null) {
                labels.add((Object)("partial:" + filter));
            }
            if ((protocolVersion = result.getProtocolVersion()) != null) {
                labels.add((Object)("protocol:" + protocolVersion));
            }
            labels.addAll((Iterable)result.getOperationType().getLabels());
        }
        return labels.build();
    }

    protected ServletInputStream getStdin() throws IOException {
        return this.request.getInputStream();
    }

    protected RpcGitTimeouts getTimeouts() {
        return RpcGitTimeouts.newBuilder().setIdle(this.config.getHostingIdleTimeout().getSeconds()).setExecution(this.config.getHostingExecutionTimeout().getSeconds()).build();
    }

    protected abstract boolean isOperationComplete();

    protected void onSuccess() {
    }

    private RpcCgiEnvironment buildCgiEnvironment() {
        RpcCgiEnvironment.Builder builder = RpcCgiEnvironment.newBuilder().setContentType(StringUtils.defaultString((String)this.request.getContentType())).setPathInfo(PathInfo.parse(() -> ((HttpServletRequest)this.request).getPathInfo()).map(PathInfo::getRelativePath).orElse("")).setQueryString(StringUtils.defaultString((String)this.request.getQueryString())).setRemoteAddr(this.request.getRemoteAddr()).setRemoteUser(this.getUsername()).setRequestMethod(this.request.getMethod()).setServerProtocol(this.request.getProtocol()).setServerSoftware(this.request.getServletContext().getServerInfo());
        if (this.request.getContentLengthLong() != -1L) {
            builder.setContentLength(this.request.getContentLengthLong());
        }
        builder.addAllExpect(Collections.list(this.request.getHeaders("expect"))).addAllHttpAccept(Collections.list(this.request.getHeaders("accept"))).addAllHttpAcceptEncoding(Collections.list(this.request.getHeaders("accept-encoding"))).setHttpContentEncoding(StringUtils.defaultString((String)this.request.getHeader("content-encoding")));
        return builder.build();
    }

    private NioStdioHandler<Void> createStdioHandler() throws IOException {
        return new CompositeNioStdioHandler((NioStdoutHandler)new CgiStdoutHandler(this.response, this.bufferSize), (NioStdinHandler)new CgiStdinHandler(this.getStdin(), this.bufferSize), null);
    }

    private String getUsername() {
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user == null) {
            return "";
        }
        return user.getName();
    }
}

