/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.http;

import com.atlassian.bitbucket.scm.CommandBuilder;
import com.google.common.collect.ImmutableSet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CgiEnvironmentUtils {
    private static final Set<String> SUPPRESSED_HTTP_HEADERS = ImmutableSet.of((Object)"AUTHORIZATION", (Object)"COOKIE", (Object)"COOKIE2", (Object)"PROXY-AUTHORIZATION", (Object)"SET-COOKIE", (Object)"SET-COOKIE2", (Object[])new String[0]);

    public static void applyStandardCgiEnvironment(CommandBuilder builder, HttpServletRequest request, ServletContext servletContext) {
        HashMap<Object, String> cgiEnv = new HashMap<Object, String>();
        cgiEnv.put("AUTH_TYPE", request.getAuthType());
        if (request.getContentLengthLong() != -1L) {
            cgiEnv.put("CONTENT_LENGTH", Long.toString(request.getContentLengthLong()));
        }
        cgiEnv.put("CONTENT_TYPE", request.getContentType());
        cgiEnv.put("GATEWAY_INTERFACE", "CGI/1.1");
        cgiEnv.put("QUERY_STRING", request.getQueryString());
        cgiEnv.put("REMOTE_ADDR", request.getRemoteAddr());
        cgiEnv.put("REMOTE_HOST", request.getRemoteHost());
        cgiEnv.put("REQUEST_METHOD", request.getMethod());
        cgiEnv.put("SERVER_NAME", request.getServerName());
        cgiEnv.put("SERVER_PORT", Integer.toString(request.getServerPort()));
        cgiEnv.put("SERVER_PROTOCOL", request.getProtocol());
        cgiEnv.put("SERVER_SOFTWARE", servletContext.getServerInfo());
        Enumeration enm = request.getHeaderNames();
        while (enm.hasMoreElements()) {
            String nameUpperCase = ((String)enm.nextElement()).toUpperCase(Locale.ROOT);
            if (SUPPRESSED_HTTP_HEADERS.contains(nameUpperCase)) continue;
            String value = request.getHeader(nameUpperCase);
            cgiEnv.put("HTTP_" + nameUpperCase.replace('-', '_'), value);
        }
        cgiEnv.put("HTTPS", request.isSecure() ? "ON" : "OFF");
        cgiEnv.entrySet().stream().filter(env -> StringUtils.isNotBlank((CharSequence)((CharSequence)env.getValue()))).forEach(env -> builder.withEnvironment((String)env.getKey(), (String)env.getValue()));
    }
}

