/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.http;

import com.atlassian.bitbucket.dmz.process.AbstractNioHandler;
import com.atlassian.bitbucket.dmz.process.NioProcess;
import com.atlassian.bitbucket.dmz.process.NioStdinHandler;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CgiStdinHandler
extends AbstractNioHandler
implements NioStdinHandler {
    private static final Logger log = LoggerFactory.getLogger(CgiStdinHandler.class);
    private final byte[] buffer;
    private final ServletInputStream stream;
    private AtomicBoolean closed;

    public CgiStdinHandler(@Nonnull ServletInputStream stream, int bufferSize) {
        this.stream = Objects.requireNonNull(stream, "stream");
        this.buffer = new byte[bufferSize];
    }

    public void onExit(int exitCode) {
        if (this.closed == null) {
            log.debug("The process was not started ({})", (Object)exitCode);
        } else {
            log.debug("[{}] has completed ({}; {})", new Object[]{this.process, exitCode, this.closed.get() ? "closed" : "not closed"});
        }
    }

    public void onStart(@Nonnull NioProcess process) {
        super.onStart(process);
        this.closed = new AtomicBoolean();
        if (this.stream.isFinished()) {
            this.close(-1);
        } else {
            process.wantWrite();
        }
    }

    public boolean onStdinReady(@Nonnull ByteBuffer stdin) {
        boolean more;
        try {
            while ((more = !this.stream.isFinished()) && stdin.hasRemaining()) {
                int read = this.stream.read(this.buffer, 0, Math.min(this.buffer.length, stdin.remaining()));
                if (read == -1) {
                    stdin.flip();
                    this.close(10);
                    return false;
                }
                stdin.put(this.buffer, 0, read);
            }
            stdin.flip();
        }
        catch (IOException e) {
            stdin.flip();
            this.close(11);
            throw new UncheckedIOException(e);
        }
        if (more) {
            return true;
        }
        this.close(12);
        return false;
    }

    private void close(int path) {
        if (this.closed.compareAndSet(false, true)) {
            try {
                log.debug("Closing request stream ({})", (Object)path);
                this.stream.close();
            }
            catch (IllegalStateException | NullPointerException ignored) {
                log.debug("Failed to close HTTP request stream; it may have already been recycled");
            }
            catch (IOException e) {
                log.warn("Failed to close HTTP request stream", (Throwable)e);
            }
            try {
                log.debug("Closing stdin ({})", (Object)path);
                this.closeStdin();
            }
            catch (RuntimeException e) {
                log.debug("Failed to close stdin; it may already be closed", (Throwable)e);
            }
        }
    }
}

