/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.http;

import com.atlassian.bitbucket.dmz.process.AbstractNioHandler;
import com.atlassian.bitbucket.dmz.process.NioStdoutHandler;
import com.atlassian.stash.internal.scm.git.protocol.http.GitHttpUtils;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CgiStdoutHandler
extends AbstractNioHandler
implements NioStdoutHandler<Void> {
    private static final Logger log = LoggerFactory.getLogger(CgiStdoutHandler.class);
    private final int bufferSize;
    private final HttpServletResponse response;
    private byte[] buffer;
    private long lastFlush;
    private OutputStream outputStream;

    public CgiStdoutHandler(@Nonnull HttpServletResponse response, int bufferSize) {
        this.bufferSize = bufferSize;
        this.response = Objects.requireNonNull(response, "response");
    }

    public Void getOutput() {
        return null;
    }

    public boolean isNioOnly() {
        return false;
    }

    public void onStdout(@Nonnull ByteBuffer stdout, boolean closed) {
        try {
            if (this.outputStream == null) {
                while (true) {
                    String line;
                    if ((line = this.getTextLineFromBuffer(stdout)) == null) {
                        if (closed) {
                            log.warn("Unexpected EOF copying SCM hosting process output to response");
                        }
                        return;
                    }
                    if (line.isEmpty()) {
                        this.buffer = new byte[this.bufferSize];
                        this.outputStream = this.response.getOutputStream();
                        break;
                    }
                    if (line.startsWith("HTTP")) continue;
                    this.processHeader(line);
                }
            }
            int start = stdout.position();
            while (stdout.hasRemaining()) {
                int read = Math.min(this.bufferSize, stdout.remaining());
                stdout.get(this.buffer, 0, read);
                this.outputStream.write(this.buffer, 0, read);
            }
            int written = stdout.position() - start;
            if (written > 0 && (long)written < 512L && System.currentTimeMillis() - this.lastFlush > 3000L) {
                this.response.flushBuffer();
                this.lastFlush = System.currentTimeMillis();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void process(@Nonnull InputStream i) throws IOException {
        try (InputStream inputStream = i;){
            String line;
            while ((line = this.getTextLineFromStream(inputStream)).length() > 0) {
                if (line.startsWith("HTTP")) continue;
                this.processHeader(line);
            }
            long total = GitHttpUtils.copyWithFlushes(inputStream, (OutputStream)this.response.getOutputStream(), this.bufferSize);
            log.trace("{} bytes copied", (Object)total);
        }
    }

    private String getTextLineFromBuffer(ByteBuffer buffer) {
        int offset = buffer.position();
        int remaining = buffer.remaining();
        for (int i = 0; i < remaining; ++i) {
            if (buffer.get(offset + i) != 10) continue;
            byte[] bytes = new byte[i + 1];
            buffer.get(bytes);
            return new String(bytes, StandardCharsets.US_ASCII).trim();
        }
        return null;
    }

    private String getTextLineFromStream(InputStream inputStream) throws IOException {
        int b;
        StringBuilder buffer = new StringBuilder();
        while ((b = inputStream.read()) != -1 && b != 10) {
            buffer.append((char)b);
        }
        return buffer.toString().trim();
    }

    private void processHeader(String line) throws IOException {
        int k = line.indexOf(58);
        if (k < 1) {
            return;
        }
        String key = line.substring(0, k).trim();
        String value = line.substring(k + 1).trim();
        if ("Location".equals(key)) {
            this.response.sendRedirect(this.response.encodeRedirectURL(value));
        } else if ("Status".equals(key)) {
            String[] token = value.split(" ");
            int status = Integer.parseInt(token[0]);
            this.response.setStatus(status);
        } else {
            this.response.addHeader(key, value);
        }
    }
}

