/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.http;

import com.atlassian.bitbucket.scm.AuthenticationState;
import com.atlassian.bitbucket.scm.git.GitUtils;
import com.atlassian.stash.internal.scm.git.protocol.http.GitHttpUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class GitHttpErrorHelper {
    private final boolean overrideResponseCode;

    public GitHttpErrorHelper(boolean overrideResponseCode) {
        this.overrideResponseCode = overrideResponseCode;
    }

    public void sendAuthenticationError(HttpServletRequest request, HttpServletResponse response, AuthenticationState state, String summary, String detailMessage) throws IOException {
        if (state == AuthenticationState.NOT_AUTHENTICATED) {
            GitHttpUtils.sendAuthenticationChallenge(response);
        } else {
            this.sendError(request, response, summary, detailMessage);
        }
    }

    public void sendError(HttpServletRequest request, HttpServletResponse response, String summary, String detailMessage) throws IOException {
        String service = request.getParameter("service");
        if (this.overrideResponseCode) {
            response.setStatus(200);
        }
        if (service != null) {
            response.setContentType("application/x-" + service + "-advertisement");
            GitHttpUtils.sendPacket(response, GitHttpUtils.asRefError(summary, detailMessage, service));
        } else {
            GitHttpUtils.sendPacket(response, GitHttpUtils.createPacket(summary + "\n" + GitUtils.wordWrap((String)detailMessage)));
        }
    }
}

