/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.http;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ScmUrlFormatter;
import com.atlassian.bitbucket.scm.ScmUrlRequest;
import com.atlassian.bitbucket.scm.http.RepositoryUrlFragment;
import com.atlassian.stash.internal.scm.git.UriEncodingUtils;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.net.URISyntaxException;

public class GitHttpUrlFormatter
implements ScmUrlFormatter {
    private final boolean includeUsername;

    public GitHttpUrlFormatter(boolean includeUsername) {
        this.includeUsername = includeUsername;
    }

    @Nonnull
    public URI format(@Nonnull ScmUrlRequest request) throws URISyntaxException {
        URI uri = request.getBaseUrl();
        String username = request.hasUser() ? request.getUser().getName() : null;
        String path = RepositoryUrlFragment.fromRepository((Repository)request.getRepository()).toPath(uri.getPath());
        return new URI(uri.getScheme(), this.includeUsername && this.isShellSafe(username) ? username : null, uri.getHost(), uri.getPort(), path + ".git", uri.getQuery(), uri.getFragment());
    }

    private boolean isShellSafe(String username) {
        if (username == null) {
            return false;
        }
        try {
            String encodedForUri = UriEncodingUtils.encodeUserInfo(username, "UTF-8");
            String encodedForShell = UriEncodingUtils.encodeComponentForShell(username, "UTF-8");
            return encodedForUri.equals(encodedForShell);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

