/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.http;

import com.atlassian.bitbucket.scm.git.GitUtils;
import com.atlassian.bitbucket.util.RequestUtils;
import com.google.common.base.Charsets;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class GitHttpUtils {
    static final int MAX_PACKET_LENGTH = Integer.decode("0xFFFF") - 4;
    private static final Logger log = LoggerFactory.getLogger(GitHttpUtils.class);

    private GitHttpUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static String asRefError(String title, String message, String service) {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append(GitHttpUtils.createPacket("# service=" + service));
        messageBuilder.append("0000");
        messageBuilder.append(GitHttpUtils.createPacket("ERR " + title + "\n" + GitUtils.wordWrap((String)message)));
        return messageBuilder.toString();
    }

    public static long copyWithFlushes(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        int read;
        byte[] buffer = new byte[bufferSize];
        long lastFlush = 0L;
        long total = 0L;
        while ((read = inputStream.read(buffer, 0, bufferSize)) != -1) {
            outputStream.write(buffer, 0, read);
            total += (long)read;
            if ((long)read >= 512L || System.currentTimeMillis() - lastFlush <= 3000L) continue;
            outputStream.flush();
            lastFlush = System.currentTimeMillis();
        }
        return total;
    }

    public static String createPacket(String line) {
        line = GitHttpUtils.trimLine(line + "\n");
        String length = StringUtils.leftPad((String)Integer.toHexString(line.length() + 4), (int)4, (String)"0");
        return length + line;
    }

    public static boolean isAsyncStarted(@Nullable HttpServletRequest request) {
        try {
            return request != null && request.isAsyncStarted();
        }
        catch (IllegalStateException | NullPointerException e) {
            log.debug("Treating recycled request as synchronous", (Throwable)e);
            return false;
        }
    }

    public static void sendAuthenticationChallenge(HttpServletResponse response) {
        HttpServletResponse unwrappedResponse = RequestUtils.unwrap((HttpServletResponse)response);
        unwrappedResponse.setHeader("WWW-Authenticate", "Basic realm=\"Atlassian Bitbucket\"");
        unwrappedResponse.setStatus(401);
    }

    public static void sendPacket(HttpServletResponse response, String packet) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), Charsets.UTF_8);
        writer.write(packet);
        ((Writer)writer).flush();
        response.flushBuffer();
    }

    public static void sendErrorAsRawPacket(HttpServletResponse response, String errorMessage) throws IOException {
        GitHttpUtils.sendPacket(response, GitHttpUtils.createPacket(errorMessage));
    }

    private static String trimLine(String line) {
        if (line.length() > MAX_PACKET_LENGTH) {
            log.warn("The provided line will not fit in a packet to send to git. Its length is {}, which is greater than the max length supported by git ({})", (Object)line.length(), (Object)MAX_PACKET_LENGTH);
            return line.substring(0, MAX_PACKET_LENGTH - 1) + "\n";
        }
        return line;
    }
}

