/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.http;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.util.RequestUtils;
import com.atlassian.stash.internal.scm.git.protocol.http.GitHttpUtils;
import com.google.common.base.Throwables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GitSmartExitHandler
implements CommandExitHandler {
    private static final Logger log = LoggerFactory.getLogger(GitSmartExitHandler.class);
    private final I18nService i18nService;
    private final String remoteHost;
    private final Repository repository;
    private final HttpServletResponse response;
    private final boolean write;
    private volatile Throwable thrown;

    public GitSmartExitHandler(I18nService i18nService, Repository repository, HttpServletRequest request, HttpServletResponse response, boolean write) {
        this.i18nService = i18nService;
        this.repository = repository;
        this.response = response;
        this.write = write;
        this.remoteHost = RequestUtils.getRemoteHost((HttpServletRequest)request);
    }

    @Nullable
    public Throwable getThrown() {
        return this.thrown;
    }

    public void onCancel(@Nonnull String command, int exitCode, String stdErr, Throwable thrown) {
        this.onExit(command, exitCode, stdErr, thrown);
    }

    public void onExit(@Nonnull String command, int exitCode, String stdErr, Throwable thrown) {
        boolean successful;
        if (this.handleUnexpectedClientHangup(stdErr)) {
            successful = true;
        } else if (this.handleMissingObjectForShallow(stdErr) || this.handleMissingRef(stdErr) || this.handleThrowable(stdErr, thrown)) {
            successful = false;
        } else if (log.isDebugEnabled() && StringUtils.isNotEmpty((CharSequence)stdErr)) {
            log.debug("{}: {} request from {} succeeded, but the following was written to stderr:\n{}", new Object[]{this.repository, this.getRequestType(), this.remoteHost, stdErr});
            successful = true;
        } else {
            successful = true;
        }
        if (successful) {
            this.onSuccess();
        } else {
            this.thrown = thrown;
        }
    }

    private String getRequestType() {
        return this.write ? "Write" : "Read";
    }

    private boolean handleMissingObjectForShallow(String stdErr) {
        if (StringUtils.startsWith((CharSequence)stdErr, (CharSequence)"fatal: did not find object for shallow")) {
            log.warn("{}: {} request from {} failed. The client mentioned a shallow object that is not present on the server. This may be triggered by rebases, or other forced updates on the server. The client should recreate their shallow clone.", new Object[]{this.repository, this.getRequestType(), this.remoteHost});
            log.debug("Error stream --> {}", (Object)stdErr);
            if (!this.response.isCommitted()) {
                try {
                    GitHttpUtils.sendErrorAsRawPacket(this.response, this.i18nService.getMessage("bitbucket.scm.git.client.request.missing.shallow.object", new Object[0]));
                }
                catch (IOException e) {
                    log.warn("Failed to write error message to git client", (Throwable)e);
                }
            }
            return true;
        }
        return false;
    }

    private boolean handleMissingRef(String stdErr) {
        if (StringUtils.startsWith((CharSequence)stdErr, (CharSequence)"fatal: git upload-pack: not our ref")) {
            log.info("{}: {} request from {} failed. A ref was requested that is no longer valid. The ref may have been updated while the request was being processed. Please try again.", new Object[]{this.repository, this.getRequestType(), this.remoteHost});
            log.debug("Error stream --> {}", (Object)stdErr);
            if (!this.response.isCommitted()) {
                try {
                    GitHttpUtils.sendErrorAsRawPacket(this.response, this.i18nService.getMessage("bitbucket.scm.git.client.request.missing.ref", new Object[0]));
                }
                catch (IOException e) {
                    log.warn("Failed to write error message to git client", (Throwable)e);
                }
            }
            return true;
        }
        return false;
    }

    private boolean handleThrowable(String stdErr, Throwable thrown) {
        Object stdErrMessage;
        if (thrown == null) {
            return false;
        }
        Throwable rootCause = Throwables.getRootCause((Throwable)thrown);
        if (rootCause instanceof SocketTimeoutException) {
            log.info("{}: {} request from {} failed due to a socket timeout", new Object[]{this.repository, this.getRequestType(), this.remoteHost, log.isDebugEnabled() ? rootCause : null});
            return true;
        }
        if (!this.response.isCommitted()) {
            this.response.setStatus(500);
        }
        Object object = stdErrMessage = StringUtils.isBlank((CharSequence)stdErr) ? "" : "\nThe following was written to stderr:\n" + stdErr;
        if (log.isDebugEnabled()) {
            log.error("{}: {} request from {} failed{}", new Object[]{this.repository, this.getRequestType(), this.remoteHost, stdErrMessage, thrown});
        } else {
            log.error("{}: {} request from {} failed: {}{}", new Object[]{this.repository, this.getRequestType(), this.remoteHost, thrown, stdErrMessage});
        }
        return true;
    }

    private boolean handleUnexpectedClientHangup(String stdErr) {
        if ("fatal: the remote end hung up unexpectedly".equalsIgnoreCase(stdErr)) {
            log.debug("{}: {} request from {} was interrupted: Is this a shallow clone request?", new Object[]{this.repository, this.getRequestType(), this.remoteHost});
            return true;
        }
        return false;
    }

    protected abstract void onSuccess();
}

