/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.http;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.help.HelpPathService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.scm.git.protocol.GitScmRequestType;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.GitWriteTracker;
import com.atlassian.stash.internal.scm.git.hosting.HookResult;
import com.atlassian.stash.internal.scm.git.hosting.HostingResult;
import com.atlassian.stash.internal.scm.git.mesh.RpcHostingClient;
import com.atlassian.stash.internal.scm.git.protocol.http.AbstractRpcHttpScmRequest;
import com.atlassian.stash.internal.scm.git.protocol.http.GitHttpErrorHelper;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

public class MeshHttpReceivePack
extends AbstractRpcHttpScmRequest {
    private final int contentLength;
    private final HelpPathService helpPathService;
    private final GitWriteTracker writeTracker;

    MeshHttpReceivePack(AuthenticationContext authenticationContext, GitScmConfig config, EventPublisher eventPublisher, GitHttpErrorHelper gitHttpErrorHelper, HelpPathService helpPathService, RpcHostingClient hostingClient, I18nService i18nService, Repository repository, HttpServletRequest request, RequestContext requestContext, RequestManager requestManager, HttpServletResponse response, GitWriteTracker writeTracker) {
        super(authenticationContext, config, eventPublisher, gitHttpErrorHelper, hostingClient, i18nService, repository, request, requestContext, requestManager, response);
        this.helpPathService = helpPathService;
        this.writeTracker = writeTracker;
        this.contentLength = request.getContentLength();
    }

    @Override
    public void handleRequest() throws IOException {
        this.writeTracker.onWriteStart();
        try {
            super.handleRequest();
        }
        finally {
            this.writeTracker.onWriteEnd();
        }
    }

    @Override
    public boolean isWrite() {
        return true;
    }

    @Override
    @Nonnull
    protected List<String> getLabels(HostingResult hostingResult) {
        ImmutableList.Builder labels = new ImmutableList.Builder().addAll(super.getLabels(hostingResult));
        if (hostingResult != null && hostingResult.getOperationType() == GitScmRequestType.PUSH) {
            HookResult hookResult = hostingResult.getHookResult();
            if (hookResult.isCalled()) {
                if (!hookResult.isAccepted()) {
                    labels.add((Object)"rejected");
                }
            } else if (hookResult != HookResult.UNSPECIFIED) {
                this.log.warn("{}: Git hooks have not been called. Please verify that the hooks are configured correctly - see {} for details", (Object)this.repository, (Object)this.helpPathService.getPageUrl("bitbucket.kb.scm.hooks.not.executing"));
            } else {
                this.log.warn("Received unexpected hook result: UNSPECIFIED ");
            }
        }
        return labels.build();
    }

    @Override
    protected boolean isOperationComplete() {
        return this.contentLength > 4 || this.contentLength == -1;
    }
}

