/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.http;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.help.HelpPathService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.scm.http.HttpScmRequest;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.GitWriteTracker;
import com.atlassian.stash.internal.scm.git.mesh.RpcHostingClient;
import com.atlassian.stash.internal.scm.git.protocol.http.AbstractGitHttpScmRequestHandler;
import com.atlassian.stash.internal.scm.git.protocol.http.GitHttpErrorHelper;
import com.atlassian.stash.internal.scm.git.protocol.http.MeshHttpOtherRead;
import com.atlassian.stash.internal.scm.git.protocol.http.MeshHttpOtherWrite;
import com.atlassian.stash.internal.scm.git.protocol.http.MeshHttpReceivePack;
import com.atlassian.stash.internal.scm.git.protocol.http.MeshHttpUploadPack;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public class MeshHttpScmRequestHandler
extends AbstractGitHttpScmRequestHandler {
    private final AuthenticationContext authenticationContext;
    private final GitScmConfig config;
    private final EventPublisher eventPublisher;
    private final HelpPathService helpPathService;
    private final RpcHostingClient hostingClient;
    private final RequestManager requestManager;
    private final GitWriteTracker writeTracker;

    public MeshHttpScmRequestHandler(AuthenticationContext authenticationContext, GitScmConfig config, EventPublisher eventPublisher, GitHttpErrorHelper gitHttpErrorHelper, HelpPathService helpPathService, RpcHostingClient hostingClient, I18nService i18nService, RepositorySupplier repositorySupplier, RequestManager requestManager, GitWriteTracker writeTracker) {
        super(authenticationContext, config, gitHttpErrorHelper, i18nService, repositorySupplier, requestManager);
        this.authenticationContext = authenticationContext;
        this.config = config;
        this.eventPublisher = eventPublisher;
        this.helpPathService = helpPathService;
        this.hostingClient = hostingClient;
        this.requestManager = requestManager;
        this.writeTracker = writeTracker;
    }

    @Override
    @Nonnull
    protected HttpScmRequest chooseHandler(AbstractGitHttpScmRequestHandler.RequestType requestType, RequestContext requestContext, Repository repository, HttpServletRequest request, HttpServletResponse response, int protocolVersion) {
        switch (requestType) {
            case OTHER_WRITE: {
                return new MeshHttpOtherWrite(this.authenticationContext, this.config, this.eventPublisher, this.gitHttpErrorHelper, this.hostingClient, this.i18nService, repository, request, requestContext, this.requestManager, response, this.writeTracker);
            }
            case OTHER_READ: {
                return new MeshHttpOtherRead(this.authenticationContext, this.config, this.eventPublisher, this.gitHttpErrorHelper, this.hostingClient, this.i18nService, repository, request, requestContext, this.requestManager, response);
            }
            case RECEIVE_PACK: {
                return new MeshHttpReceivePack(this.authenticationContext, this.config, this.eventPublisher, this.gitHttpErrorHelper, this.helpPathService, this.hostingClient, this.i18nService, repository, request, requestContext, this.requestManager, response, this.writeTracker);
            }
            case UPLOAD_PACK: {
                return new MeshHttpUploadPack(this.authenticationContext, this.config, this.eventPublisher, this.gitHttpErrorHelper, this.hostingClient, this.i18nService, repository, request, requestContext, this.requestManager, response);
            }
        }
        throw new IllegalStateException("Unhandled request type " + String.valueOf((Object)requestType));
    }
}

