/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.http;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.event.repository.RepositoryOtherReadEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.scm.cache.internal.event.AnalyticsRepositoryCloneEvent;
import com.atlassian.bitbucket.scm.cache.internal.event.AnalyticsRepositoryPullEvent;
import com.atlassian.bitbucket.scm.git.protocol.GitScmRequestType;
import com.atlassian.bitbucket.util.web.AsyncListenerSupport;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.hosting.HostingResult;
import com.atlassian.stash.internal.scm.git.mesh.RpcHostingClient;
import com.atlassian.stash.internal.scm.git.protocol.http.AbstractRpcHttpScmRequest;
import com.atlassian.stash.internal.scm.git.protocol.http.GitHttpErrorHelper;
import com.atlassian.stash.internal.scm.git.protocol.http.GitHttpUtils;
import com.atlassian.util.contentcache.CacheResult;
import jakarta.annotation.Nonnull;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;

public class MeshHttpUploadPack
extends AbstractRpcHttpScmRequest {
    private GitScmRequestType requestType = GitScmRequestType.UNKNOWN;

    MeshHttpUploadPack(AuthenticationContext authenticationContext, GitScmConfig config, EventPublisher eventPublisher, GitHttpErrorHelper gitHttpErrorHelper, RpcHostingClient hostingClient, I18nService i18nService, Repository repository, HttpServletRequest request, RequestContext requestContext, RequestManager requestManager, HttpServletResponse response) {
        super(authenticationContext, config, eventPublisher, gitHttpErrorHelper, hostingClient, i18nService, repository, request, requestContext, requestManager, response);
    }

    @Override
    @Nonnull
    protected List<String> getLabels(HostingResult hostingResult) {
        if (hostingResult != null) {
            this.requestType = hostingResult.getOperationType();
        }
        return super.getLabels(hostingResult);
    }

    @Override
    protected boolean isOperationComplete() {
        return true;
    }

    @Override
    protected void onSuccess() {
        if (GitHttpUtils.isAsyncStarted(this.request)) {
            final Runnable task = this.requestContext.wrap(this::fireEvent);
            this.request.getAsyncContext().addListener((AsyncListener)new AsyncListenerSupport(this){

                public void onComplete(AsyncEvent event) {
                    task.run();
                }
            });
        } else {
            this.requestContext.addCleanupCallback(this::fireEvent);
        }
    }

    private void fireEvent() {
        if (this.requestType == GitScmRequestType.REFS) {
            this.eventPublisher.publish((Object)new RepositoryOtherReadEvent((Object)this, this.repository));
        } else if (this.requestType.isClone()) {
            this.eventPublisher.publish((Object)new AnalyticsRepositoryCloneEvent((Object)this, this.getRepository(), this.requestContext, "http", CacheResult.MISS));
        } else {
            this.eventPublisher.publish((Object)new AnalyticsRepositoryPullEvent((Object)this, this.getRepository(), this.requestContext, "http"));
        }
    }
}

