/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.http;

import com.atlassian.stash.internal.scm.git.protocol.RepositoryPath;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PathInfo {
    private final String relativePath;
    private final RepositoryPath repositoryPath;
    private final RequestCategory requestCategory;

    private PathInfo(RepositoryPath repositoryPath, String relativePath, RequestCategory requestCategory) {
        this.repositoryPath = repositoryPath;
        this.relativePath = relativePath;
        this.requestCategory = requestCategory;
    }

    @Nonnull
    public static Optional<PathInfo> parse(@Nonnull Supplier<String> supplier) {
        String pathInfo = supplier.get();
        if (pathInfo == null) {
            return Optional.empty();
        }
        return Arrays.stream(PathInfoMatcher.values()).map(matcher -> matcher.parse(pathInfo)).filter(Objects::nonNull).findFirst();
    }

    @Nonnull
    public String getRelativePath() {
        return this.relativePath;
    }

    @Nonnull
    public Optional<RepositoryPath> getRepositoryPath() {
        return Optional.ofNullable(this.repositoryPath);
    }

    public boolean isDumb() {
        return this.requestCategory == RequestCategory.DUMB;
    }

    public boolean isReceive() {
        return this.requestCategory == RequestCategory.RECEIVE_PACK;
    }

    public boolean isUpload() {
        return this.requestCategory == RequestCategory.UPLOAD_PACK;
    }

    private static enum RequestCategory {
        DUMB,
        RECEIVE_PACK,
        UNKNOWN,
        UPLOAD_PACK;

    }

    private static enum PathInfoMatcher {
        RECEIVE_PACK("/git-receive-pack$", RequestCategory.RECEIVE_PACK),
        UPLOAD_PACK("/git-upload-pack$", RequestCategory.UPLOAD_PACK),
        ALTERNATES("/objects/info/alternates$", RequestCategory.DUMB),
        HEAD("/HEAD$", RequestCategory.DUMB),
        HTTP_ALTERNATES("/objects/info/http-alternates$", RequestCategory.DUMB),
        INDEX("/objects/pack/pack-[0-9a-f]{40}\\.idx$", RequestCategory.DUMB),
        OBJECTS("/objects/[0-9a-f]{2}/[0-9a-f]{38}$", RequestCategory.DUMB),
        PACK("/objects/pack/pack-[0-9a-f]{40}\\.pack$", RequestCategory.DUMB),
        PACK_LIST("/objects/info/packs$", RequestCategory.DUMB),
        REFS("/info/refs$", RequestCategory.DUMB),
        ANYTHING_ELSE("$", RequestCategory.UNKNOWN);

        private static final Pattern PATTERN_SLASH;
        private final Pattern suffixMatcher;
        private final RequestCategory requestCategory;

        private PathInfoMatcher(String suffixMatcher, RequestCategory requestCategory) {
            this.suffixMatcher = Pattern.compile(suffixMatcher);
            this.requestCategory = requestCategory;
        }

        @Nullable
        PathInfo parse(@Nonnull String pathInfo) {
            Objects.requireNonNull(pathInfo, "pathInfo");
            Matcher matcher = this.suffixMatcher.matcher(pathInfo);
            if (matcher.find()) {
                StringBuffer repositoryAddress = new StringBuffer();
                matcher.appendReplacement(repositoryAddress, "");
                String[] addressSegments = PATTERN_SLASH.split(StringUtils.removeStart((String)repositoryAddress.toString(), (String)"/"));
                if (addressSegments.length < 2 || addressSegments.length > 3 || Arrays.stream(addressSegments).anyMatch(StringUtils::isBlank)) {
                    return null;
                }
                int offset = addressSegments.length == 3 ? 1 : 0;
                String projectKey = addressSegments[offset++];
                String repositorySlug = StringUtils.removeEnd((String)addressSegments[offset], (String)".git");
                return new PathInfo(new RepositoryPath(projectKey, repositorySlug), matcher.group(0), this.requestCategory);
            }
            return null;
        }

        static {
            PATTERN_SLASH = Pattern.compile("/");
        }
    }
}

