/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.ssh;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryMovedException;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.scm.git.protocol.ssh.GitSshScmRequestHandler;
import com.atlassian.stash.internal.scm.git.protocol.RepositoryPath;
import com.atlassian.stash.internal.scm.git.protocol.ssh.GitSshUtils;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGitSshScmRequestHandler
implements GitSshScmRequestHandler {
    private static final Pattern PATTERN_GIT_COMMAND = Pattern.compile("git-([^\\s]+)(.*)");
    private static final Pattern PATTERN_REPOSITORY_PATH = Pattern.compile("\\s*'/?(?:([^/]+)/)?([^/]+)/([^/']+?)(?:\\.git)?'");
    protected final I18nService i18nService;
    protected final Logger log;
    private final RepositorySupplier repositorySupplier;

    protected AbstractGitSshScmRequestHandler(I18nService i18nService, RepositorySupplier repositorySupplier) {
        this.i18nService = i18nService;
        this.repositorySupplier = repositorySupplier;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    protected Repository getRepositoryOrThrow(ParsedCommand command) {
        RepositoryPath repositoryPath = this.parseArguments(command.getArgument());
        if (repositoryPath == null) {
            this.log.debug("Repository information could not be extracted from {}", (Object)command);
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.git.ssh.url.invalid.message", new Object[]{Product.NAME, command.getArgument().trim()});
            throw new NoSuchRepositoryException(message, null);
        }
        try {
            Repository repository = this.repositorySupplier.getBySlug(repositoryPath.getProjectKey(), repositoryPath.getRepositorySlug());
            if (repository == null) {
                KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.scm.no.such.repository.detail", new Object[0]);
                throw new NoSuchRepositoryException(message, null);
            }
            return repository;
        }
        catch (RepositoryMovedException e) {
            return e.getRepository();
        }
    }

    protected Optional<ParsedCommand> parseCommand(String command) {
        String cmd;
        Matcher matcher = PATTERN_GIT_COMMAND.matcher(command);
        if (matcher.matches() && GitSshUtils.SUPPORTED_COMMANDS.contains(cmd = matcher.group(1))) {
            return Optional.of(new ParsedCommand(cmd, matcher.group(2)));
        }
        return Optional.empty();
    }

    private RepositoryPath parseArguments(String arguments) {
        Matcher matcher = PATTERN_REPOSITORY_PATH.matcher(arguments);
        if (matcher.matches()) {
            String projectKey = matcher.group(2);
            String repositorySlug = matcher.group(3);
            this.log.trace("Extracted project key {} and repository slug {}; loading repository", (Object)projectKey, (Object)repositorySlug);
            return new RepositoryPath(projectKey, repositorySlug);
        }
        return null;
    }

    protected static class ParsedCommand {
        private final String command;
        private final String argument;

        ParsedCommand(String command, String argument) {
            this.command = command;
            this.argument = argument;
        }

        public String getCommand() {
            return this.command;
        }

        public String getArgument() {
            return this.argument;
        }

        public String toString() {
            return "git-" + this.command + this.argument;
        }
    }
}

