/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.ssh;

import com.atlassian.bitbucket.ResourceBusyException;
import com.atlassian.bitbucket.dmz.process.CompositeNioStdioHandler;
import com.atlassian.bitbucket.dmz.process.NioProcess;
import com.atlassian.bitbucket.dmz.process.NioStderrHandler;
import com.atlassian.bitbucket.dmz.process.NioStdinHandler;
import com.atlassian.bitbucket.dmz.process.NioStdioHandler;
import com.atlassian.bitbucket.dmz.process.NioStdoutHandler;
import com.atlassian.bitbucket.dmz.ssh.SshInputStream;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitTimeouts;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryOfflineException;
import com.atlassian.bitbucket.repository.RepositoryReadOnlyException;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.Watchdog;
import com.atlassian.bitbucket.scm.ssh.SshScmRequest;
import com.atlassian.bitbucket.scm.ssh.SshScmRequestContext;
import com.atlassian.stash.internal.scm.git.CountUpDownLatch;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.hosting.HostingResult;
import com.atlassian.stash.internal.scm.git.mesh.RpcHostingClient;
import com.atlassian.stash.internal.scm.git.protocol.ssh.GitSshUtils;
import com.atlassian.stash.internal.scm.git.protocol.ssh.SshCommandExitHandler;
import com.atlassian.stash.internal.scm.git.protocol.ssh.SshStderrHandler;
import com.atlassian.stash.internal.scm.git.protocol.ssh.SshStdinHandler;
import com.atlassian.stash.internal.scm.git.protocol.ssh.SshStdoutHandler;
import com.atlassian.util.contentcache.CacheResult;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

abstract class AbstractRpcSshScmRequest
implements SshScmRequest {
    protected final SshScmRequestContext context;
    protected final Logger log;
    protected final RpcHostingClient hostingClient;
    protected final Repository repository;
    private final int bufferSize;
    private final String command;
    private final GitScmConfig config;
    private final SshCommandExitHandler exitHandler;
    private final CountUpDownLatch latch;
    private final RequestManager requestManager;
    private volatile SshStdoutHandler stdoutHandler;
    private volatile boolean wrappedUp;

    AbstractRpcSshScmRequest(String command, GitScmConfig config, SshScmRequestContext context, RpcHostingClient hostingClient, I18nService i18nService, Repository repository, RequestManager requestManager) {
        this.command = "git-" + command;
        this.config = config;
        this.context = context;
        this.hostingClient = hostingClient;
        this.repository = repository;
        this.requestManager = requestManager;
        this.bufferSize = 16384;
        this.exitHandler = new SshCommandExitHandler(this, i18nService, context.getStderr()){

            @Override
            public void onExit(@Nonnull String command, int exitCode, String stdErr, Throwable thrown) {
                if (thrown instanceof RepositoryOfflineException || thrown instanceof RepositoryReadOnlyException || thrown instanceof ResourceBusyException) {
                    throw (RuntimeException)thrown;
                }
                super.onExit(command, exitCode, stdErr, thrown);
            }
        };
        this.latch = new CountUpDownLatch(0);
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public void cancel() {
        try {
            this.latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SshStdoutHandler stdoutHandler = this.stdoutHandler;
        if (stdoutHandler == null) {
            this.log.debug("{} was canceled before git could be started", (Object)this.command);
        } else {
            stdoutHandler.cancel();
            if (this.wrappedUp) {
                this.log.trace("{} completed", (Object)this.command);
            }
        }
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest() throws IOException {
        this.latch.countUp();
        HostingResult hostingResult = null;
        if (this.context.getEnvironment().containsKey("BB_IS_MIRROR")) {
            LocaleContextHolder.setLocale((Locale)Locale.US);
        }
        try {
            if (this.stdoutHandler != null) {
                throw new IllegalStateException("handleRequest() must only be invoked once");
            }
            hostingResult = this.dispatchRpc((NioStdioHandler<Void>)new CompositeNioStdioHandler((NioStdoutHandler)new LatchedSshStdoutHandler(), (NioStdinHandler)new SshStdinHandler(this.getStdin(), this.bufferSize), (NioStderrHandler)new SshStderrHandler(this.context.getStderr(), this.bufferSize)), this.exitHandler);
        }
        catch (Throwable throwable) {
            try {
                this.onFinished(hostingResult);
            }
            finally {
                LocaleContextHolder.resetLocaleContext();
                this.latch.countDown();
            }
            throw throwable;
        }
        try {
            this.onFinished(hostingResult);
        }
        finally {
            LocaleContextHolder.resetLocaleContext();
            this.latch.countDown();
        }
    }

    public boolean isWrite() {
        return false;
    }

    public void sendError(@Nonnull String summary, @Nonnull String detailMessage) throws IOException {
        GitSshUtils.sendError(this.context.getStderr(), summary, detailMessage);
    }

    @Nonnull
    protected abstract HostingResult dispatchRpc(NioStdioHandler<Void> var1, CommandExitHandler var2);

    @Nonnull
    protected List<String> getLabels(HostingResult hostingResult) {
        ImmutableList.Builder labels = new ImmutableList.Builder();
        if (hostingResult != null) {
            Integer protocolVersion;
            String filter;
            CacheResult cacheResult = hostingResult.getCacheResult();
            if (cacheResult != null) {
                labels.add((Object)cacheResult.toString());
            }
            if ((filter = hostingResult.getFilter()) != null) {
                labels.add((Object)("partial:" + filter));
            }
            if ((protocolVersion = hostingResult.getProtocolVersion()) != null) {
                labels.add((Object)("protocol:" + protocolVersion));
            }
            labels.addAll((Iterable)hostingResult.getOperationType().getLabels());
        }
        return labels.build();
    }

    protected SshInputStream getStdin() {
        return (SshInputStream)this.context.getStdin();
    }

    protected RpcGitTimeouts getTimeouts() {
        return RpcGitTimeouts.newBuilder().setIdle(this.config.getHostingIdleTimeout().getSeconds()).setExecution(this.config.getHostingExecutionTimeout().getSeconds()).build();
    }

    protected void onSuccess() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFinished(HostingResult hostingResult) {
        if (this.wrappedUp) {
            return;
        }
        try {
            Integer exitCode = this.exitHandler.getExitCode();
            if (exitCode == null) {
                this.log.warn("{} did not complete. It will be assumed the command failed", (Object)this.command);
            } else {
                this.log.trace("{} completed with exit code {}", (Object)this.command, (Object)exitCode);
                this.context.getExitCodeCallback().onExit(exitCode.intValue());
                if (exitCode == 0) {
                    this.onSuccess();
                }
            }
        }
        finally {
            try {
                RequestContext requestContext = this.requestManager.getRequestContext();
                if (requestContext != null && hostingResult != null) {
                    this.getLabels(hostingResult).forEach(arg_0 -> ((RequestContext)requestContext).addLabel(arg_0));
                }
            }
            finally {
                this.wrappedUp = true;
            }
        }
    }

    private final class LatchedSshStdoutHandler
    extends SshStdoutHandler {
        LatchedSshStdoutHandler() {
            super(AbstractRpcSshScmRequest.this.context.getStdout(), AbstractRpcSshScmRequest.this.bufferSize);
        }

        public void onStart(@Nonnull NioProcess process) {
            super.onStart(process);
            this.afterStart();
        }

        @Override
        public void setWatchdog(@Nonnull Watchdog watchdog) {
            super.setWatchdog(watchdog);
            this.afterStart();
        }

        private void afterStart() {
            AbstractRpcSshScmRequest.this.stdoutHandler = this;
            AbstractRpcSshScmRequest.this.latch.countDown();
        }
    }
}

