/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.ssh;

import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.stash.internal.scm.git.protocol.ssh.AbstractSshHandler;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Objects;

public abstract class AbstractSshOutputHandler
extends AbstractSshHandler
implements CommandOutputHandler<Void> {
    private final OutputStream outputStream;

    public AbstractSshOutputHandler(@Nonnull OutputStream outputStream, int bufferSize) {
        super(bufferSize);
        this.outputStream = Objects.requireNonNull(outputStream, "outputStream");
    }

    public Void getOutput() {
        return null;
    }

    public void process(@Nonnull InputStream output) throws IOException {
        try (InputStream inputStream = output;){
            this.copyStream(inputStream, this.outputStream);
        }
    }

    protected void writeBuffer(@Nonnull ByteBuffer output) {
        try {
            int read;
            for (int remaining = output.remaining(); remaining > 0; remaining -= read) {
                read = Math.min(this.buffer.length, remaining);
                output.get(this.buffer, 0, read);
                this.outputStream.write(this.buffer, 0, read);
            }
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

