/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.ssh;

import com.atlassian.bitbucket.scm.git.GitUtils;
import com.atlassian.bitbucket.scm.ssh.SshScmRequestContext;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class GitSshUtils {
    public static final String COMMAND_RECEIVE_PACK = "receive-pack";
    public static final String COMMAND_UPLOAD_ARCHIVE = "upload-archive";
    public static final String COMMAND_UPLOAD_PACK = "upload-pack";
    public static final String ENV_BB_IS_MIRROR = "BB_IS_MIRROR";
    public static final Set<String> SUPPORTED_COMMANDS = ImmutableSet.of((Object)"receive-pack", (Object)"upload-archive", (Object)"upload-pack");

    private GitSshUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    @Nonnull
    public static String pickHostingResource(@Nonnull SshScmRequestContext context) {
        Objects.requireNonNull(context, "context");
        String resource = (String)context.getEnvironment().get(ENV_BB_IS_MIRROR);
        if (StringUtils.isNotBlank((CharSequence)resource)) {
            return "mirror-hosting";
        }
        return "scm-hosting";
    }

    public static void sendError(OutputStream stream, String summary, String detailedMessage) throws IOException {
        String message = "fatal: remote error: " + summary + "\n" + GitUtils.wordWrap((String)detailedMessage) + "\n";
        stream.write(message.getBytes());
        stream.flush();
    }
}

