/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.ssh;

import com.atlassian.bitbucket.dmz.process.NioStdioHandler;
import com.atlassian.bitbucket.help.HelpPathService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcReceivePackRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.git.protocol.GitScmRequestType;
import com.atlassian.bitbucket.scm.ssh.SshScmRequestContext;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.GitWriteTracker;
import com.atlassian.stash.internal.scm.git.hosting.HookResult;
import com.atlassian.stash.internal.scm.git.hosting.HostingResult;
import com.atlassian.stash.internal.scm.git.mesh.RpcHostingClient;
import com.atlassian.stash.internal.scm.git.protocol.ssh.AbstractRpcSshScmRequest;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;

public class MeshSshReceivePack
extends AbstractRpcSshScmRequest {
    private final HelpPathService helpPathService;
    private final GitWriteTracker writeTracker;
    private boolean success;

    public MeshSshReceivePack(GitScmConfig config, SshScmRequestContext context, HelpPathService helpPathService, RpcHostingClient hostingClient, I18nService i18nService, Repository repository, RequestManager requestManager, GitWriteTracker writeTracker) {
        super("receive-pack", config, context, hostingClient, i18nService, repository, requestManager);
        this.helpPathService = helpPathService;
        this.writeTracker = writeTracker;
    }

    @Override
    public boolean isWrite() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    protected HostingResult dispatchRpc(NioStdioHandler<Void> stdioHandler, CommandExitHandler exitHandler) {
        RpcReceivePackRequest.Builder builder = RpcReceivePackRequest.newBuilder().setTimeouts(this.getTimeouts());
        this.writeTracker.onWriteStart();
        try {
            HostingResult hostingResult = this.hostingClient.receivePack(this.repository, builder, stdioHandler, exitHandler);
            return hostingResult;
        }
        finally {
            this.writeTracker.onWriteEnd();
        }
    }

    @Override
    @Nonnull
    protected List<String> getLabels(HostingResult hostingResult) {
        ImmutableList.Builder labels = new ImmutableList.Builder().addAll(super.getLabels(hostingResult));
        if (this.success && hostingResult != null && hostingResult.getOperationType() == GitScmRequestType.PUSH) {
            HookResult hookResult = hostingResult.getHookResult();
            if (hookResult.isCalled()) {
                if (!hookResult.isAccepted()) {
                    labels.add((Object)"rejected");
                }
            } else if (hookResult != HookResult.UNSPECIFIED) {
                this.log.warn("{}: Git hooks have not been called. Please verify that the hooks are configured correctly - see {} for details", (Object)this.repository, (Object)this.helpPathService.getPageUrl("bitbucket.kb.scm.hooks.not.executing"));
            } else {
                this.log.warn("Received unexpected hook result: UNSPECIFIED ");
            }
        }
        return labels.build();
    }

    @Override
    protected void onSuccess() {
        this.success = true;
    }
}

