/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.ssh;

import com.atlassian.bitbucket.help.HelpPathService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.scm.ssh.SshScmRequest;
import com.atlassian.bitbucket.scm.ssh.SshScmRequestContext;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.GitWriteTracker;
import com.atlassian.stash.internal.scm.git.mesh.RpcHostingClient;
import com.atlassian.stash.internal.scm.git.protocol.ssh.AbstractGitSshScmRequestHandler;
import com.atlassian.stash.internal.scm.git.protocol.ssh.MeshSshReceivePack;
import com.atlassian.stash.internal.scm.git.protocol.ssh.MeshSshUploadArchive;
import com.atlassian.stash.internal.scm.git.protocol.ssh.MeshSshUploadPack;
import jakarta.annotation.Nonnull;
import java.util.Optional;

public class MeshSshScmRequestHandler
extends AbstractGitSshScmRequestHandler {
    private final GitScmConfig config;
    private final EventPublisher eventPublisher;
    private final HelpPathService helpPathService;
    private final RpcHostingClient hostingClient;
    private final RequestManager requestManager;
    private final GitWriteTracker writeTracker;

    public MeshSshScmRequestHandler(I18nService i18nService, RepositorySupplier repositorySupplier, GitScmConfig config, EventPublisher eventPublisher, HelpPathService helpPathService, RpcHostingClient hostingClient, RequestManager requestManager, GitWriteTracker writeTracker) {
        super(i18nService, repositorySupplier);
        this.config = config;
        this.eventPublisher = eventPublisher;
        this.helpPathService = helpPathService;
        this.hostingClient = hostingClient;
        this.requestManager = requestManager;
        this.writeTracker = writeTracker;
    }

    @Nonnull
    public Optional<SshScmRequest> create(@Nonnull SshScmRequestContext context) {
        return this.parseCommand(context.getCommand()).map(command -> {
            Repository repository = this.getRepositoryOrThrow((AbstractGitSshScmRequestHandler.ParsedCommand)command);
            switch (command.getCommand()) {
                case "receive-pack": {
                    return new MeshSshReceivePack(this.config, context, this.helpPathService, this.hostingClient, this.i18nService, repository, this.requestManager, this.writeTracker);
                }
                case "upload-archive": {
                    return new MeshSshUploadArchive(this.config, context, this.hostingClient, this.i18nService, repository, this.requestManager);
                }
                case "upload-pack": {
                    return new MeshSshUploadPack(this.config, context, this.eventPublisher, this.hostingClient, this.i18nService, repository, this.requestManager);
                }
            }
            throw new IllegalStateException("Could not create an SSH request for supported operation " + String.valueOf(command));
        });
    }

    public boolean supports(@Nonnull String command) {
        return this.parseCommand(command).isPresent();
    }
}

