/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.ssh;

import com.atlassian.bitbucket.dmz.process.NioStdioHandler;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcThrottledResource;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUploadPackRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.cache.internal.event.AnalyticsRepositoryCloneEvent;
import com.atlassian.bitbucket.scm.cache.internal.event.AnalyticsRepositoryPullEvent;
import com.atlassian.bitbucket.scm.git.protocol.GitScmRequestType;
import com.atlassian.bitbucket.scm.ssh.SshScmRequestContext;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.hosting.HostingResult;
import com.atlassian.stash.internal.scm.git.mesh.RpcHostingClient;
import com.atlassian.stash.internal.scm.git.protocol.ssh.AbstractRpcSshScmRequest;
import com.atlassian.util.contentcache.CacheResult;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MeshSshUploadPack
extends AbstractRpcSshScmRequest {
    private final EventPublisher eventPublisher;
    private final RequestManager requestManager;
    private GitScmRequestType requestType;

    public MeshSshUploadPack(GitScmConfig config, SshScmRequestContext context, EventPublisher eventPublisher, RpcHostingClient hostingClient, I18nService i18nService, Repository repository, RequestManager requestManager) {
        super("upload-pack", config, context, hostingClient, i18nService, repository, requestManager);
        this.eventPublisher = eventPublisher;
        this.requestManager = requestManager;
        this.requestType = GitScmRequestType.UNKNOWN;
    }

    @Override
    @Nonnull
    protected HostingResult dispatchRpc(NioStdioHandler<Void> stdioHandler, CommandExitHandler exitHandler) {
        RpcThrottledResource resource = StringUtils.isBlank((CharSequence)((CharSequence)this.context.getEnvironment().get("BB_IS_MIRROR"))) ? RpcThrottledResource.RESOURCE_PACK : RpcThrottledResource.RESOURCE_MIRROR_PACK;
        RpcUploadPackRequest.Builder builder = RpcUploadPackRequest.newBuilder().setStrict(true).setThrottledResource(resource).setTimeouts(this.getTimeouts());
        String protocol = (String)this.context.getEnvironment().get("GIT_PROTOCOL");
        if (StringUtils.isNotBlank((CharSequence)protocol)) {
            builder.setProtocolEnv(protocol);
        }
        return this.hostingClient.uploadPack(this.repository, builder, stdioHandler, exitHandler);
    }

    @Override
    @Nonnull
    protected List<String> getLabels(HostingResult hostingResult) {
        if (hostingResult != null) {
            this.requestType = hostingResult.getOperationType();
        }
        return super.getLabels(hostingResult);
    }

    @Override
    protected void onSuccess() {
        RequestContext requestContext = this.requestManager.getRequestContext();
        if (requestContext != null && this.requestType != GitScmRequestType.REFS) {
            requestContext.addCleanupCallback(() -> this.eventPublisher.publish(this.requestType.isClone() ? new AnalyticsRepositoryCloneEvent((Object)this, this.repository, requestContext, "ssh", CacheResult.MISS) : new AnalyticsRepositoryPullEvent((Object)this, this.repository, requestContext, "ssh")));
        }
    }
}

