/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.protocol.ssh;

import com.atlassian.bitbucket.dmz.process.NioProcess;
import com.atlassian.bitbucket.dmz.process.NioStdinHandler;
import com.atlassian.bitbucket.dmz.ssh.SshInputStream;
import com.atlassian.bitbucket.dmz.ssh.SshReadListener;
import com.atlassian.stash.internal.scm.git.protocol.ssh.AbstractSshHandler;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class SshStdinHandler
extends AbstractSshHandler
implements NioStdinHandler {
    private final SshInputStream inputStream;
    private volatile boolean open;
    private AtomicBoolean writeRequested;

    public SshStdinHandler(@Nonnull SshInputStream inputStream, int bufferSize) {
        super(bufferSize);
        this.inputStream = Objects.requireNonNull(inputStream, "inputStream");
        this.open = true;
    }

    public void onExit(int exitCode) {
        this.open = false;
    }

    public void onStart(@Nonnull NioProcess process) {
        super.onStart(process);
        this.writeRequested = new AtomicBoolean();
        this.inputStream.setReadListener((SshReadListener)new ProcessReadListener(process));
    }

    public boolean onStdinReady(@Nonnull ByteBuffer stdin) {
        this.writeRequested.set(false);
        try {
            while (this.inputStream.isReady() && stdin.hasRemaining()) {
                int read = this.inputStream.read(this.buffer, 0, Math.min(this.buffer.length, stdin.remaining()));
                if (read == -1) {
                    stdin.flip();
                    this.closeStdin();
                    return false;
                }
                stdin.put(this.buffer, 0, read);
            }
            stdin.flip();
        }
        catch (IOException e) {
            this.log.warn("Failed to copy request input to SCM hosting process", (Throwable)(this.log.isDebugEnabled() ? e : null));
            stdin.flip();
            this.closeStdin();
            return false;
        }
        return this.inputStream.isReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean closeStdin() {
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            if (this.open) {
                this.open = false;
                this.process.closeStdin(false);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    private class ProcessReadListener
    implements SshReadListener {
        private final NioProcess process;

        ProcessReadListener(NioProcess process) {
            this.process = process;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onDataAvailable() {
            if (!SshStdinHandler.this.open || !SshStdinHandler.this.writeRequested.compareAndSet(false, true)) return;
            byte[] byArray = SshStdinHandler.this.buffer;
            synchronized (SshStdinHandler.this.buffer) {
                if (!SshStdinHandler.this.open) return;
                if (SshStdinHandler.this.inputStream.isFinished()) {
                    SshStdinHandler.this.log.debug("EOF has been signaled, with no further stdin to read");
                    SshStdinHandler.this.open = false;
                    try {
                        this.process.closeStdin(false);
                    }
                    catch (RuntimeException e) {
                        SshStdinHandler.this.log.debug("Failed to close stdin after receiving EOF; it may already be closed", (Throwable)e);
                    }
                } else {
                    this.requestWrite();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private void requestWrite() {
            block5: {
                try {
                    this.process.wantWrite();
                }
                catch (RuntimeException e) {
                    if (this.process.isRunning() && !this.process.isCanceled()) {
                        if (SshStdinHandler.this.log.isDebugEnabled()) {
                            SshStdinHandler.this.log.warn("wantWrite() failed", (Throwable)e);
                        } else {
                            SshStdinHandler.this.log.warn("wantWrite() failed: {}", (Object)e.toString());
                        }
                    }
                    if (!SshStdinHandler.this.log.isDebugEnabled()) break block5;
                    SshStdinHandler.this.log.debug("wantWrite() failed due to concurrent completion", (Throwable)e);
                }
            }
        }
    }
}

