/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.pull;

import com.atlassian.bitbucket.migration.ArchiveSource;
import com.atlassian.bitbucket.migration.SequentialArchive;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.scm.git.pull.AnalyticsPullRequestMergeTypeChangedEvent;
import com.atlassian.stash.internal.scm.git.pull.GitPullRequestCache;
import com.atlassian.stash.internal.scm.git.pull.GitPullRequestCachedAncestorDao;
import com.atlassian.stash.internal.scm.git.pull.GitPullRequestCachedMergeDao;
import com.atlassian.stash.internal.scm.git.pull.InternalGitPullRequestCachedAncestor;
import com.atlassian.stash.internal.scm.git.pull.InternalGitPullRequestCachedMerge;
import com.atlassian.stash.internal.scm.git.pull.LegacyPullRequestMergeCache;
import com.atlassian.stash.internal.scm.git.pull.PullRequestMergeType;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Transactional(readOnly=true)
public class DefaultGitPullRequestCache
implements GitPullRequestCache {
    static final String ARCHIVE_CACHED_ANCESTOR = "cached-ancestor.txt";
    static final String ARCHIVE_CACHED_MERGE = "cached-merge.txt";
    private final GitPullRequestCachedAncestorDao cachedAncestorDao;
    private final GitPullRequestCachedMergeDao cachedMergeDao;
    private final EventPublisher eventPublisher;
    private final LegacyPullRequestMergeCache mergeCache;
    private final TransactionTemplate transactionTemplate;

    public DefaultGitPullRequestCache(GitPullRequestCachedAncestorDao cachedAncestorDao, GitPullRequestCachedMergeDao cachedMergeDao, EventPublisher eventPublisher, LegacyPullRequestMergeCache mergeCache, PlatformTransactionManager transactionManager) {
        this.cachedAncestorDao = cachedAncestorDao;
        this.cachedMergeDao = cachedMergeDao;
        this.eventPublisher = eventPublisher;
        this.mergeCache = mergeCache;
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @Override
    public void exportByPullRequest(@Nonnull PullRequest pullRequest, @Nonnull SequentialArchive archive) throws IOException {
        InternalGitPullRequestCachedMerge merge;
        InternalGitPullRequestCachedAncestor ancestor = this.cachedAncestorDao.findByPullRequest(pullRequest);
        if (ancestor != null) {
            archive.addEntry(Paths.get(ARCHIVE_CACHED_ANCESTOR, new String[0]), outputStream -> {
                String line = ancestor.getFromHash() + "," + ancestor.getToHash() + "," + ancestor.getAncestorHash();
                outputStream.write(line.getBytes(StandardCharsets.UTF_8));
            });
        }
        if ((merge = this.cachedMergeDao.findByPullRequest(pullRequest)) != null) {
            archive.addEntry(Paths.get(ARCHIVE_CACHED_MERGE, new String[0]), outputStream -> {
                String line = merge.getFromHash() + "," + merge.getToHash() + ",," + merge.getType();
                outputStream.write(line.getBytes(StandardCharsets.UTF_8));
            });
        }
    }

    @Override
    public String getCommonAncestor(@Nonnull PullRequest pullRequest) {
        InternalGitPullRequestCachedAncestor cached = this.cachedAncestorDao.findByPullRequestIfCurrent(pullRequest);
        return cached == null ? null : cached.getAncestorHash();
    }

    @Override
    public PullRequestMergeType getMergeType(@Nonnull PullRequest pullRequest, boolean locked) {
        InternalGitPullRequestCachedMerge cached = this.cachedMergeDao.findByPullRequest(pullRequest);
        if (cached == null) {
            if (locked && this.mergeCache != null) {
                PullRequestMergeType type = this.mergeCache.get(pullRequest);
                if (type != null) {
                    this.transactionTemplate.execute(status -> (InternalGitPullRequestCachedMerge)this.cachedMergeDao.create((Object)new InternalGitPullRequestCachedMerge.Builder(pullRequest).type(type.getId()).build()));
                }
                return type;
            }
        } else if (cached.isCurrent(pullRequest)) {
            return PullRequestMergeType.fromId((int)cached.getType());
        }
        return null;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void importForPullRequest(@Nonnull PullRequest pullRequest, @Nonnull ArchiveSource source) throws IOException {
        source.read(entry -> {
            String entryName = entry.getPath().toString();
            if (ARCHIVE_CACHED_ANCESTOR.equals(entryName)) {
                entry.read(inputStream -> {
                    String line = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    String[] fields = line.split(",");
                    this.cachedAncestorDao.create((Object)((InternalGitPullRequestCachedAncestor.Builder)((InternalGitPullRequestCachedAncestor.Builder)new InternalGitPullRequestCachedAncestor.Builder(pullRequest).ancestorHash(fields[2]).fromHash(fields[0])).toHash(fields[1])).build());
                });
            } else if (ARCHIVE_CACHED_MERGE.equals(entryName)) {
                entry.read(inputStream -> {
                    String line = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    String[] fields = line.split(",");
                    this.cachedMergeDao.create((Object)((InternalGitPullRequestCachedMerge.Builder)((InternalGitPullRequestCachedMerge.Builder)new InternalGitPullRequestCachedMerge.Builder(pullRequest).fromHash(fields[0])).toHash(fields[1])).type(Integer.parseInt(fields[3])).build());
                });
            } else {
                throw new IOException("Unexpected archive entry while importing pull request caches: " + entryName);
            }
        });
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void putCommonAncestor(@Nonnull PullRequest pullRequest, @Nonnull String commonAncestor) {
        this.cachedAncestorDao.update((Object)new InternalGitPullRequestCachedAncestor.Builder(pullRequest).ancestorHash(commonAncestor).build());
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void putMergeType(@Nonnull PullRequest pullRequest, @Nonnull PullRequestMergeType type) {
        InternalGitPullRequestCachedMerge cached = this.cachedMergeDao.findByPullRequest(pullRequest);
        if (cached != null && cached.getType() != type.getId()) {
            this.eventPublisher.publish((Object)new AnalyticsPullRequestMergeTypeChangedEvent(this, pullRequest, type, PullRequestMergeType.fromId((int)cached.getType())));
        }
        this.cachedMergeDao.update((Object)new InternalGitPullRequestCachedMerge.Builder(pullRequest).type(type.getId()).build());
    }
}

