/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.pull;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.concurrent.PullRequestLock;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.pull.IllegalPullRequestStateException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestOutOfDateException;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryArchivedException;
import com.atlassian.bitbucket.repository.SimpleBranch;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.scm.git.GitFeature;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitExtendedCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitRebaseCommandParameters;
import com.atlassian.bitbucket.scm.git.command.rebase.GitRebaseWorkflowsDisabledException;
import com.atlassian.bitbucket.scm.git.pull.GitPullRequestRebasedEvent;
import com.atlassian.bitbucket.scm.git.pull.GitPullRequestService;
import com.atlassian.bitbucket.scm.git.pull.PullRequestRebaseRequest;
import com.atlassian.bitbucket.scm.git.pull.PullRequestRebaseability;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.pull.GitPullRequestSupplier;
import com.atlassian.stash.internal.scm.git.pull.SimplePullRequestRebaseVeto;
import com.atlassian.stash.internal.scm.git.pull.SimplePullRequestRebaseability;
import com.atlassian.stash.internal.scm.git.rebase.SimpleGitRebaseHookRequest;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitPullRequestService
implements GitPullRequestService {
    private final AuthenticationContext authenticationContext;
    private final GitScmConfig config;
    private final EventPublisher eventPublisher;
    private final GitExtendedCommandFactory extendedCommandFactory;
    private final FeatureManager featureManager;
    private final RepositoryHookService hookService;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final GitPullRequestSupplier pullRequestSupplier;
    private final PullRequestLock rebaseLock;

    public DefaultGitPullRequestService(AuthenticationContext authenticationContext, GitScmConfig config, EventPublisher eventPublisher, GitExtendedCommandFactory extendedCommandFactory, FeatureManager featureManager, RepositoryHookService hookService, I18nService i18nService, PermissionService permissionService, GitPullRequestSupplier pullRequestSupplier, PullRequestLock rebaseLock) {
        this.authenticationContext = authenticationContext;
        this.config = config;
        this.eventPublisher = eventPublisher;
        this.extendedCommandFactory = extendedCommandFactory;
        this.featureManager = featureManager;
        this.hookService = hookService;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.pullRequestSupplier = pullRequestSupplier;
        this.rebaseLock = rebaseLock;
    }

    @Nonnull
    public PullRequestRebaseability canRebase(@Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        if (this.isRebaseDisabled()) {
            return new SimplePullRequestRebaseability.Builder().veto(new SimplePullRequestRebaseVeto(this.i18nService.getMessage("bitbucket.git.service.pullrequest.rebase.featuredisabled", new Object[0]), this.i18nService.getMessage("bitbucket.git.service.pullrequest.rebase.featuredisabled.detail", new Object[0]))).build();
        }
        PullRequestRef fromRef = pullRequest.getFromRef();
        PullRequestRef toRef = pullRequest.getToRef();
        Repository repository = fromRef.getRepository();
        SimpleGitRebaseHookRequest hookRequest = ((SimpleGitRebaseHookRequest.Builder)new SimpleGitRebaseHookRequest.Builder(repository).branch(DefaultGitPullRequestService.convertRefToBranch(fromRef)).dryRun(true)).upstream(toRef.getLatestCommit()).upstreamRepository(toRef.getRepository()).build();
        RepositoryHookResult result = this.hookService.preUpdate((RepositoryHookRequest)hookRequest);
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        boolean canWrite = this.permissionService.hasRepositoryPermission(repository, Permission.REPO_WRITE);
        boolean canRebase = canWrite && pullRequest.isOpen() && StringUtils.startsWith((CharSequence)fromRef.getId(), (CharSequence)"refs/heads/") && currentUser != null && StringUtils.isNotBlank((CharSequence)currentUser.getEmailAddress()) && "git".equals(repository.getScmId());
        SimplePullRequestRebaseability.Builder builder = new SimplePullRequestRebaseability.Builder().canRebase(canRebase).canWrite(canWrite);
        if (!canWrite) {
            builder.veto(new SimplePullRequestRebaseVeto(this.i18nService.getMessage("bitbucket.git.service.pullrequest.rebase.notwritable", new Object[]{repository.getProject().getKey(), repository.getSlug()}), this.i18nService.getMessage("bitbucket.git.service.pullrequest.rebase.notwritable.detail", new Object[]{fromRef.getDisplayId(), toRef.getDisplayId()})));
        }
        if (result.isRejected()) {
            result.getVetoes().stream().map(SimplePullRequestRebaseVeto::new).forEach(builder::veto);
        }
        return builder.build();
    }

    @Nonnull
    public Optional<RefChange> rebase(@Nonnull PullRequestRebaseRequest request) {
        Objects.requireNonNull(request, "request");
        if (this.isRebaseDisabled()) {
            throw new GitRebaseWorkflowsDisabledException(this.i18nService.createKeyedMessage("bitbucket.git.service.pullrequest.rebase.featuredisabled", new Object[0]));
        }
        ApplicationUser committer = this.authenticationContext.getCurrentUser();
        if (committer == null) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.git.service.pullrequest.rebase.anonymous", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)committer.getEmailAddress())) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.git.service.pullrequest.rebase.committer.email", new Object[]{committer.getName()}));
        }
        PullRequest pullRequest = this.getPullRequestOrFail(request.getRepositoryId(), request.getPullRequestId(), request.getVersion());
        if (pullRequest.getToRef().getRepository().isArchived()) {
            throw new RepositoryArchivedException(this.i18nService.getKeyedText(new I18nKey("bitbucket.git.service.pullrequest.rebase.repoarchived", new Object[0])));
        }
        PullRequestRef fromRef = pullRequest.getFromRef();
        if (!StringUtils.startsWith((CharSequence)fromRef.getId(), (CharSequence)"refs/heads/")) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.git.service.pullrequest.rebase.fromrefnotbranch", new Object[]{fromRef.getDisplayId()}));
        }
        Repository fromRepository = fromRef.getRepository();
        if (!"git".equals(fromRepository.getScmId())) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.git.service.pullrequest.rebase.notgit", new Object[0]));
        }
        if (!this.permissionService.hasRepositoryPermission(fromRepository, Permission.REPO_WRITE)) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.git.service.pullrequest.rebase.notwritable", new Object[]{fromRepository.getProject().getKey(), fromRepository.getSlug()}));
        }
        try (Timer ignored = TimerUtils.start((String)DefaultGitPullRequestService.timerName(pullRequest));){
            Optional optional = (Optional)this.rebaseLock.withLock(pullRequest, (Operation)new RebaseOperation(request, committer));
            return optional;
        }
    }

    private static Branch convertRefToBranch(PullRequestRef fromRef) {
        return ((SimpleBranch.Builder)((SimpleBranch.Builder)((SimpleBranch.Builder)new SimpleBranch.Builder().displayId(fromRef.getDisplayId())).id(fromRef.getId())).latestCommit(fromRef.getLatestCommit())).build();
    }

    private boolean isRebaseDisabled() {
        return !this.featureManager.isEnabled((Feature)GitFeature.REBASE_WORKFLOWS);
    }

    private static boolean isRebased(@Nonnull Branch branch, @Nullable Branch rebased) {
        return rebased != null && !rebased.getLatestCommit().equals(branch.getLatestCommit());
    }

    private static String timerName(PullRequest pullRequest) {
        return "git: rebase " + pullRequest.getToRef().getRepository().getId() + ":" + pullRequest.getId() + "@" + pullRequest.getVersion();
    }

    private PullRequest getPullRequestOrFail(int repositoryId, long pullRequestId, int version) {
        PullRequest pullRequest = this.pullRequestSupplier.getById(repositoryId, pullRequestId);
        if (pullRequest.getVersion() != version) {
            throw new PullRequestOutOfDateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.outofdate", new Object[0]), pullRequest, version);
        }
        if (pullRequest.isLocked()) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.git.service.pullrequest.rebase.merging", new Object[0]));
        }
        switch (pullRequest.getState()) {
            case DECLINED: {
                throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.git.service.pullrequest.rebase.declined", new Object[0]));
            }
            case MERGED: {
                throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.git.service.pullrequest.rebase.merged", new Object[0]));
            }
        }
        return pullRequest;
    }

    private class RebaseOperation
    implements UncheckedOperation<Optional<RefChange>> {
        private final int repositoryId;
        private final long pullRequestId;
        private final int version;
        private final ApplicationUser committer;

        public RebaseOperation(PullRequestRebaseRequest request, ApplicationUser committer) {
            this.committer = committer;
            this.repositoryId = request.getRepositoryId();
            this.pullRequestId = request.getPullRequestId();
            this.version = request.getVersion();
        }

        public Optional<RefChange> perform() {
            PullRequest pullRequest = DefaultGitPullRequestService.this.getPullRequestOrFail(this.repositoryId, this.pullRequestId, this.version);
            PullRequestRef fromRef = pullRequest.getFromRef();
            PullRequestRef toRef = pullRequest.getToRef();
            Branch branch = DefaultGitPullRequestService.convertRefToBranch(fromRef);
            GitCommand command = DefaultGitPullRequestService.this.extendedCommandFactory.rebase(fromRef.getRepository(), new GitRebaseCommandParameters.Builder(branch, toRef.getLatestCommit()).committer(this.committer).commitRequired(true).upstreamRepository(toRef.getRepository()).build());
            command.setTimeout(DefaultGitPullRequestService.this.config.getRebaseTimeout());
            Branch rebased = (Branch)command.call();
            if (DefaultGitPullRequestService.isRebased(branch, rebased)) {
                SimpleRefChange refChange = ((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder().fromHash(fromRef.getLatestCommit())).to((Ref)rebased)).type(RefChangeType.UPDATE)).build();
                DefaultGitPullRequestService.this.eventPublisher.publish((Object)new GitPullRequestRebasedEvent((Object)this, pullRequest, (RefChange)refChange));
                return Optional.of(refChange);
            }
            return Optional.empty();
        }
    }
}

