/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.pull;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.NoSuchPullRequestException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.stash.internal.scm.git.pull.GitPullRequestSupplier;
import jakarta.annotation.Nonnull;

public class DefaultGitPullRequestSupplier
implements GitPullRequestSupplier {
    private final I18nService i18nService;
    private final PullRequestService pullRequestService;
    private final RepositoryService repositoryService;

    public DefaultGitPullRequestSupplier(I18nService i18nService, PullRequestService pullRequestService, RepositoryService repositoryService) {
        this.i18nService = i18nService;
        this.pullRequestService = pullRequestService;
        this.repositoryService = repositoryService;
    }

    @Override
    @Nonnull
    public PullRequest getById(int repositoryId, long pullRequestId) {
        PullRequest pullRequest = this.pullRequestService.getById(repositoryId, pullRequestId);
        if (pullRequest == null) {
            Repository repository = this.repositoryService.getById(repositoryId);
            if (repository == null) {
                throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.git.pullrequest.nosuchrepository", new Object[]{repositoryId}), null);
            }
            throw new NoSuchPullRequestException(this.i18nService.createKeyedMessage("bitbucket.git.pullrequest.nosuchpullrequest", new Object[]{pullRequestId, repository.getProject().getKey(), repository.getSlug()}));
        }
        return pullRequest;
    }
}

