/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.pull;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.scm.git.GitUtils;
import com.atlassian.stash.internal.scm.git.GitAgent;
import com.atlassian.stash.internal.scm.git.pull.PullRequestRefBuilder;
import com.atlassian.stash.internal.scm.git.pull.PullRequestRefType;
import com.atlassian.stash.internal.scm.git.pull.PullRequestRefs;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class DefaultPullRequestRefs
implements PullRequestRefs {
    private final GitAgent agent;
    private final String darkFromId;
    private final String darkMergeId;
    private final String darkToId;
    private final String publicFromId;
    private final String publicMergeId;
    private final PullRequest pullRequest;
    private Branch darkFrom;
    private Branch darkMerge;
    private Branch darkTo;
    private Branch publicFrom;
    private Branch publicMerge;

    public DefaultPullRequestRefs(GitAgent agent, PullRequest pullRequest) {
        this.agent = Objects.requireNonNull(agent, "agent");
        this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
        PullRequestRefBuilder builder = PullRequestRefBuilder.darkRef().id(pullRequest);
        this.darkFromId = builder.type(PullRequestRefType.FROM).toRef();
        this.darkMergeId = builder.type(PullRequestRefType.MERGE).toRef();
        this.darkToId = builder.type(PullRequestRefType.TO).toRef();
        builder = PullRequestRefBuilder.publicRef().id(pullRequest);
        this.publicFromId = builder.type(PullRequestRefType.FROM).toRef();
        this.publicMergeId = builder.type(PullRequestRefType.MERGE).toRef();
    }

    @Override
    @Nonnull
    public String getDarkFrom() {
        return this.darkFromId;
    }

    @Override
    @Nonnull
    public String getDarkMerge() {
        return this.darkMergeId;
    }

    @Override
    @Nonnull
    public String getDarkTo() {
        return this.darkToId;
    }

    @Override
    @Nonnull
    public String getPublicFrom() {
        return this.publicFromId;
    }

    @Override
    @Nonnull
    public String getPublicMerge() {
        return this.publicMergeId;
    }

    @Override
    public boolean isDarkFromOutdated() {
        return !GitUtils.refsMatch((Ref)this.pullRequest.getFromRef(), (Ref)this.resolveDarkFrom());
    }

    @Override
    public Branch resolveDarkFrom() {
        if (this.darkFrom == null) {
            this.darkFrom = this.resolve(this.darkFromId);
        }
        return this.darkFrom;
    }

    @Override
    public Branch resolveDarkMerge() {
        if (this.darkMerge == null) {
            this.darkMerge = this.resolve(this.darkMergeId);
        }
        return this.darkMerge;
    }

    @Override
    public Branch resolveDarkTo() {
        if (this.darkTo == null) {
            this.darkTo = this.resolve(this.darkToId);
        }
        return this.darkTo;
    }

    @Override
    public Branch resolvePublicFrom() {
        if (this.publicFrom == null) {
            this.publicFrom = this.resolve(this.publicFromId);
        }
        return this.publicFrom;
    }

    @Override
    public Branch resolvePublicMerge() {
        if (this.publicMerge == null) {
            this.publicMerge = this.resolve(this.publicMergeId);
        }
        return this.publicMerge;
    }

    private Branch resolve(String refId) {
        return this.agent.resolveBranch(this.pullRequest.getToRef().getRepository(), refId, true);
    }
}

