/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.pull;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.stash.internal.scm.git.porcelain.AbstractTimedRequest;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class GitPullRequestContext
extends AbstractTimedRequest {
    private final Person author;
    private final String idAtVersion;
    private final PullRequest pullRequest;

    private GitPullRequestContext(@Nonnull Builder builder) {
        super(builder);
        this.author = builder.author;
        this.pullRequest = builder.pullRequest;
        this.idAtVersion = this.pullRequest.getId() + "@" + this.pullRequest.getVersion();
    }

    @Nonnull
    public Person getAuthor() {
        return this.author;
    }

    @Nonnull
    public PullRequestRef getFromRef() {
        return this.pullRequest.getFromRef();
    }

    @Nonnull
    public Repository getFromRepository() {
        return this.getFromRef().getRepository();
    }

    @Nonnull
    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Nonnull
    public PullRequestRef getToRef() {
        return this.pullRequest.getToRef();
    }

    @Nonnull
    public Repository getToRepository() {
        return this.getToRef().getRepository();
    }

    public boolean isCrossRepository() {
        return this.getFromRepository().getId() != this.getToRepository().getId();
    }

    public String toString() {
        return this.idAtVersion;
    }

    public static class Builder
    extends AbstractTimedRequest.AbstractBuilder<Builder, GitPullRequestContext> {
        private final PullRequest pullRequest;
        private Person author;

        public Builder(@Nonnull PullRequest pullRequest) {
            this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
        }

        @Nonnull
        public Builder author(@Nonnull Person value) {
            this.author = Objects.requireNonNull(value, "author");
            return this.self();
        }

        @Override
        @Nonnull
        public GitPullRequestContext build() {
            Objects.requireNonNull(this.author, "author");
            return new GitPullRequestContext(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

