/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.pull;

import com.atlassian.bitbucket.content.ChangeType;
import com.atlassian.bitbucket.content.Conflict;
import com.atlassian.bitbucket.content.ConflictChange;
import com.atlassian.bitbucket.content.SimpleConflict;
import com.atlassian.bitbucket.content.SimpleConflictChange;
import com.atlassian.bitbucket.io.LineReader;
import com.atlassian.bitbucket.io.ReaderLineReader;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MergeConflictNoteReader {
    private final LineReader reader;

    public MergeConflictNoteReader(Reader reader) {
        this.reader = new ReaderLineReader(LineReader.Mode.MODE_UNIX, reader);
    }

    @Nonnull
    public Map<String, Conflict> readConflicts() throws IOException {
        String line;
        HashMap<String, Conflict> conflicts = new HashMap<String, Conflict>();
        this.reader.readLine();
        this.reader.readLine();
        HashSet<String> paths = new HashSet<String>(6, 1.0f);
        while ((line = this.reader.readLine()) != null) {
            String nextLine;
            if (line.isEmpty()) continue;
            if (!line.startsWith("Conflict")) {
                throw new IllegalStateException("Note is incorrectly structured; found [" + line + "] where a conflict header was expected");
            }
            if (line.endsWith("\\")) {
                StringBuilder builder = new StringBuilder(line);
                do {
                    builder.deleteCharAt(builder.length() - 1);
                    line = this.reader.readLine();
                    if (line == null) {
                        throw new IllegalStateException("Note ended unexpectedly while reading conflict header; read so far:\n" + String.valueOf(builder));
                    }
                    builder.append("\n").append(line);
                } while (line.endsWith("\\"));
                line = builder.toString();
            }
            if ((nextLine = this.reader.readLine()) == null) {
                throw new IllegalStateException("Note ended unexpectedly while parsing changes for conflict [" + line + "]");
            }
            if (!nextLine.startsWith("\t")) {
                throw new IllegalStateException("Note is incorrectly structured; found [" + nextLine + "] where a change description was expected");
            }
            SimpleConflictChange change = this.parseChange(nextLine.substring(1), paths);
            SimpleConflict.Builder builder = new SimpleConflict.Builder().ourChange((ConflictChange)change);
            nextLine = this.reader.readLine();
            if (nextLine != null && nextLine.startsWith("\t")) {
                builder.theirChange((ConflictChange)this.parseChange(nextLine.substring(1), paths));
            } else {
                builder.theirChange((ConflictChange)change);
                this.reader.pushLineBack(nextLine);
            }
            SimpleConflict conflict = builder.build();
            if (conflict.getOurChange() == conflict.getTheirChange()) {
                paths.forEach(path -> conflicts.putIfAbsent((String)path, (Conflict)conflict));
            } else {
                paths.forEach(path -> conflicts.put((String)path, (Conflict)conflict));
            }
            paths.clear();
        }
        return conflicts;
    }

    private SimpleConflictChange parseChange(String line, Set<String> paths) {
        String[] pieces = line.split("\\|");
        if (pieces.length < 2 || pieces.length > 3) {
            throw new IllegalStateException("Change description [" + line + "] contains " + pieces.length + "pieces where 2 or 3 were expected");
        }
        String path = pieces[1];
        int rename = path.indexOf("->");
        if (rename != -1) {
            String tmpPath = path.substring(rename + 2);
            paths.add(tmpPath);
            path = path.substring(0, rename);
        }
        paths.add(path);
        SimpleConflictChange.Builder builder = new SimpleConflictChange.Builder().type(ChangeType.valueOf((String)pieces[0])).path(path);
        if (pieces.length == 3) {
            paths.add(pieces[2]);
            builder.srcPath(pieces[2]);
        }
        return builder.build();
    }
}

