/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.pull;

import com.atlassian.bitbucket.content.ChangeType;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.AbstractPathGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.AddAddGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.AddRenameGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.ContentGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.ConvergentDirectoryRenameGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.ConvergentRenameGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.DeleteModifyGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.DeleteRenameGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.DirectoryFileGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.DivergentDirectoryRenameGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.DivergentRenameGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.FileDirectoryGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.GitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.GitMergeConflictVisitor;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.ImplicitDirectoryRenameGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.MergedRenameGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.ModifyDeleteGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.RenameAddGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.RenameDeleteGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.SubmoduleGitMergeConflict;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.UnknownGitMergeConflict;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;

public class MergeConflictNoteWriter {
    private final GitMergeConflictVisitor conflictWriter;
    private final Writer writer;

    public MergeConflictNoteWriter(Writer writer) {
        this.writer = writer;
        this.conflictWriter = new WriterGitMergeConflictVisitor();
    }

    public void writeBranches(@Nonnull PullRequest pullRequest) throws IOException {
        this.writer.write("From: " + pullRequest.getFromRef().getDisplayId());
        this.writer.write(10);
        this.writer.write("To: " + pullRequest.getToRef().getDisplayId());
        this.writer.write(10);
    }

    public void writeConflict(@Nonnull GitMergeConflict conflict) throws IOException {
        try {
            conflict.accept(this.conflictWriter);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private class WriterGitMergeConflictVisitor
    implements GitMergeConflictVisitor {
        private WriterGitMergeConflictVisitor() {
        }

        public void visit(@Nonnull AddAddGitMergeConflict conflict) {
            this.visitPathConflict((AbstractPathGitMergeConflict)conflict);
        }

        public void visit(@Nonnull AddRenameGitMergeConflict conflict) {
            try {
                this.writeConflict((GitMergeConflict)conflict);
                this.writeChange(conflict.getOurChange(), conflict.getPath(), null);
                this.writeChange(conflict.getTheirChange(), conflict.getPath(), conflict.getTheirSrcPath());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void visit(@Nonnull ContentGitMergeConflict conflict) {
            this.visitPathConflict((AbstractPathGitMergeConflict)conflict);
        }

        public void visit(@Nonnull ConvergentDirectoryRenameGitMergeConflict conflict) {
        }

        public void visit(@Nonnull ConvergentRenameGitMergeConflict conflict) {
            try {
                this.writeConflict((GitMergeConflict)conflict);
                this.writeChange(conflict.getOurChange(), conflict.getPath(), conflict.getOurSrcPath());
                this.writeChange(conflict.getTheirChange(), conflict.getPath(), conflict.getTheirSrcPath());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void visit(@Nonnull DeleteModifyGitMergeConflict conflict) {
            this.visitPathConflict((AbstractPathGitMergeConflict)conflict);
        }

        public void visit(@Nonnull DeleteRenameGitMergeConflict conflict) {
            if (conflict.getTheirSrcPath() == null) {
                this.visitPathConflict((AbstractPathGitMergeConflict)conflict);
            } else {
                try {
                    this.writeConflict((GitMergeConflict)conflict);
                    this.writeChange(conflict.getOurChange(), conflict.getTheirSrcPath(), null);
                    this.writeChange(conflict.getTheirChange(), conflict.getPath(), conflict.getTheirSrcPath());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }

        public void visit(@Nonnull DirectoryFileGitMergeConflict conflict) {
            try {
                this.writeConflict((GitMergeConflict)conflict);
                this.writeChange(conflict.getOurChange(), conflict.getPath() + "/", null);
                this.writeChange(conflict.getTheirChange(), conflict.getPath(), null);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void visit(@Nonnull DivergentDirectoryRenameGitMergeConflict conflict) {
        }

        public void visit(@Nonnull DivergentRenameGitMergeConflict conflict) {
            try {
                this.writeConflict((GitMergeConflict)conflict);
                this.writeChange(conflict.getOurChange(), conflict.getOurPath(), conflict.getSrcPath());
                this.writeChange(conflict.getTheirChange(), conflict.getTheirPath(), conflict.getSrcPath());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void visit(@Nonnull FileDirectoryGitMergeConflict conflict) {
            try {
                this.writeConflict((GitMergeConflict)conflict);
                this.writeChange(conflict.getOurChange(), conflict.getPath(), null);
                this.writeChange(conflict.getTheirChange(), conflict.getPath() + "/", null);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void visit(@Nonnull ImplicitDirectoryRenameGitMergeConflict conflict) {
        }

        public void visit(@Nonnull MergedRenameGitMergeConflict conflict) {
            try {
                this.writeConflict((GitMergeConflict)conflict);
                this.writeChange(conflict.getOurChange(), conflict.getPath(), conflict.getOurSrcPath());
                this.writeChange(conflict.getTheirChange(), conflict.getPath(), conflict.getTheirSrcPath());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void visit(@Nonnull ModifyDeleteGitMergeConflict conflict) {
            this.visitPathConflict((AbstractPathGitMergeConflict)conflict);
        }

        public void visit(@Nonnull RenameAddGitMergeConflict conflict) {
            try {
                this.writeConflict((GitMergeConflict)conflict);
                this.writeChange(conflict.getOurChange(), conflict.getPath(), conflict.getOurSrcPath());
                this.writeChange(conflict.getTheirChange(), conflict.getPath(), null);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void visit(@Nonnull RenameDeleteGitMergeConflict conflict) {
            if (conflict.getOurSrcPath() == null) {
                this.visitPathConflict((AbstractPathGitMergeConflict)conflict);
            } else {
                try {
                    this.writeConflict((GitMergeConflict)conflict);
                    this.writeChange(conflict.getOurChange(), conflict.getPath(), conflict.getOurSrcPath());
                    this.writeChange(conflict.getTheirChange(), conflict.getOurSrcPath(), null);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }

        public void visit(@Nonnull SubmoduleGitMergeConflict conflict) {
            this.visitPathConflict((AbstractPathGitMergeConflict)conflict);
        }

        public void visit(@Nonnull UnknownGitMergeConflict conflict) {
        }

        private void visitPathConflict(AbstractPathGitMergeConflict conflict) {
            try {
                this.writeConflict((GitMergeConflict)conflict);
                ChangeType ourChange = conflict.getOurChange();
                ChangeType theirChange = conflict.getTheirChange();
                this.writeChange(ourChange, conflict.getPath(), null);
                if (ourChange != theirChange) {
                    this.writeChange(theirChange, conflict.getPath(), null);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private void writeChange(ChangeType type, String path, String srcPath) throws IOException {
            MergeConflictNoteWriter.this.writer.write(9);
            MergeConflictNoteWriter.this.writer.write(type.name());
            MergeConflictNoteWriter.this.writer.write(124);
            MergeConflictNoteWriter.this.writer.write(path);
            if (srcPath != null) {
                MergeConflictNoteWriter.this.writer.write("|");
                MergeConflictNoteWriter.this.writer.write(srcPath);
            }
            MergeConflictNoteWriter.this.writer.write(10);
        }

        private void writeConflict(GitMergeConflict conflict) throws IOException {
            MergeConflictNoteWriter.this.writer.write("Conflict: (");
            MergeConflictNoteWriter.this.writer.write(conflict.getType().getReason());
            MergeConflictNoteWriter.this.writer.write(") ");
            MergeConflictNoteWriter.this.writer.write(conflict.getMessage());
            MergeConflictNoteWriter.this.writer.write(10);
        }
    }
}

