/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.pull;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestPropertyContext;
import com.atlassian.bitbucket.pull.PullRequestPropertyProvider;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.scm.git.pull.GitPullRequestCachedMergeDao;
import com.atlassian.stash.internal.scm.git.pull.PullRequestMergeType;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.function.Function;

public class MergeResultPullRequestPropertyProvider
implements PullRequestPropertyProvider {
    private final GitPullRequestCachedMergeDao cachedMergeDao;

    public MergeResultPullRequestPropertyProvider(GitPullRequestCachedMergeDao cachedMergeDao) {
        this.cachedMergeDao = cachedMergeDao;
    }

    public void provideProperties(@Nonnull PullRequestPropertyContext context) {
        Map pullRequestsById = (Map)MoreStreams.streamIterable((Iterable)context).filter(pullRequest -> pullRequest.getState() != PullRequestState.MERGED && "git".equals(pullRequest.getToRef().getRepository().getScmId())).map(InternalPullRequest.class::cast).collect(MoreCollectors.toImmutableMap(InternalPullRequest::getGlobalId, Function.identity()));
        if (pullRequestsById.isEmpty()) {
            return;
        }
        this.cachedMergeDao.getByIds(pullRequestsById.keySet()).forEach(cachedMerge -> {
            PullRequest pullRequest = (PullRequest)pullRequestsById.get(cachedMerge.getId());
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"outcome", (Object)PullRequestMergeType.fromId((int)cachedMerge.getType()).toOutcome());
            builder.put((Object)"current", (Object)cachedMerge.isCurrent(pullRequest));
            context.setProperty(pullRequest, "mergeResult", (Object)builder.build());
        });
    }
}

