/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.pull;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.util.FileUtils;
import com.atlassian.stash.internal.scm.git.pull.PullRequestRefType;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class PullRequestRefBuilder {
    private static final String[] PATH_DARK_REFLOGS = new String[]{"logs", "stash-refs", "pull-requests"};
    private static final String[] PATH_DARK_REFS = new String[]{"stash-refs", "pull-requests"};
    private static final String[] PATH_PUBLIC_REFLOGS = new String[]{"logs", "refs", "pull-requests"};
    private static final String[] PATH_PUBLIC_REFS = new String[]{"refs", "pull-requests"};
    private final String[] prefix;
    private Long id;
    private String name;

    private PullRequestRefBuilder(String[] prefix) {
        this.prefix = prefix;
    }

    @Nonnull
    public static PullRequestRefBuilder darkRef() {
        return new PullRequestRefBuilder(PATH_DARK_REFS);
    }

    @Nonnull
    public static PullRequestRefBuilder darkReflogs() {
        return new PullRequestRefBuilder(PATH_DARK_REFLOGS);
    }

    @Nonnull
    public static PullRequestRefBuilder publicRef() {
        return new PullRequestRefBuilder(PATH_PUBLIC_REFS);
    }

    @Nonnull
    public static PullRequestRefBuilder publicReflogs() {
        return new PullRequestRefBuilder(PATH_PUBLIC_REFLOGS);
    }

    @Nonnull
    public static Stream<PullRequestRefBuilder> stream(long pullRequestId) {
        return Stream.of(PullRequestRefBuilder.publicRef(), PullRequestRefBuilder.darkRef(), PullRequestRefBuilder.publicReflogs(), PullRequestRefBuilder.darkReflogs()).map(builder -> builder.id(pullRequestId));
    }

    @Nonnull
    public PullRequestRefBuilder id(@Nonnull PullRequest pullRequest) {
        return this.id(Objects.requireNonNull(pullRequest, "pullRequest").getId());
    }

    @Nonnull
    public PullRequestRefBuilder id(@Nonnull Long value) {
        this.id = Objects.requireNonNull(value, "id");
        return this;
    }

    @Nonnull
    public PullRequestRefBuilder name(@Nonnull String value) {
        this.name = Objects.requireNonNull(value, "name");
        return this;
    }

    @Nonnull
    public String[] toArray() {
        if (this.id == null) {
            return this.prefix;
        }
        String[] path = new String[this.prefix.length + (this.name == null ? 1 : 2)];
        System.arraycopy(this.prefix, 0, path, 0, this.prefix.length);
        path[this.prefix.length] = String.valueOf(this.id);
        if (this.name != null) {
            path[this.prefix.length + 1] = this.name;
        }
        return path;
    }

    @Nonnull
    public File toFile(@Nonnull File repositoryDir) {
        return FileUtils.construct((File)Objects.requireNonNull(repositoryDir, "repositoryDir"), (String[])this.toArray());
    }

    @Nonnull
    public Path toPath(@Nonnull Path repositoryDir) {
        return Objects.requireNonNull(repositoryDir, "repositoryDir").resolve(this.toRef());
    }

    @Nonnull
    public String toRef() {
        return StringUtils.join((Object[])this.toArray(), (String)"/");
    }

    public String toString() {
        return this.toRef();
    }

    @Nonnull
    public PullRequestRefBuilder type(@Nonnull PullRequestRefType value) {
        return this.name(Objects.requireNonNull(value, "type").getRefName());
    }

    @Nonnull
    public PullRequestRefBuilder version(@Nonnull PullRequest pullRequest) {
        return this.id(pullRequest).version(pullRequest.getVersion());
    }

    @Nonnull
    public PullRequestRefBuilder version(int version) {
        return this.name("v" + version);
    }
}

