/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.pull;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.stash.internal.scm.git.pull.PullRequestRefType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PullRequestRefGuardHook
implements PreRepositoryHook<RepositoryHookRequest> {
    public static final List<Pattern> RESERVED_PATTERNS = ImmutableList.of((Object)Pattern.compile("refs/notes/pull-requests(?:/\\d+(?:/([^/]+))?)?$"), (Object)Pattern.compile("refs/pull-requests(?:/\\d+(?:/([^/]+))?)?$"));
    public static final Set<String> RESERVED_NAMES = ImmutableSet.builder().add((Object)PullRequestRefType.FROM.getRefName()).add((Object)PullRequestRefType.MERGE.getRefName()).build();
    private final I18nService i18nService;

    public PullRequestRefGuardHook(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull RepositoryHookRequest request) {
        TreeSet rejected = Sets.newTreeSet();
        for (RefChange refChange : request.getRefChanges()) {
            String refId = refChange.getRef().getId();
            if (!PullRequestRefGuardHook.isReserved(refId)) continue;
            rejected.add(refId);
        }
        if (rejected.isEmpty()) {
            return RepositoryHookResult.accepted();
        }
        String summary = this.i18nService.getMessage("bitbucket.scm.git.pull.refreserved", new Object[]{Product.NAME});
        StringBuilder details = new StringBuilder("Rejected refs:\n");
        for (String ref : rejected) {
            details.append("\t").append(ref).append("\n");
        }
        return RepositoryHookResult.rejected((String)summary, (String)details.toString());
    }

    private static boolean isReserved(String refId) {
        for (Pattern pattern : RESERVED_PATTERNS) {
            Matcher matcher = pattern.matcher(refId);
            if (!matcher.matches()) continue;
            String name = matcher.group(1);
            return name == null || RESERVED_NAMES.contains(name);
        }
        return false;
    }
}

