/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.pull;

import com.atlassian.bitbucket.scm.git.pull.PullRequestRebaseVeto;
import com.atlassian.bitbucket.scm.git.pull.PullRequestRebaseability;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Objects;

public class SimplePullRequestRebaseability
implements PullRequestRebaseability {
    private final boolean canRebase;
    private final boolean canWrite;
    private final Collection<PullRequestRebaseVeto> vetoes;

    public SimplePullRequestRebaseability(Builder builder) {
        this.canRebase = builder.canRebase;
        this.canWrite = builder.canWrite;
        this.vetoes = builder.vetoes.build();
    }

    public boolean canRebase() {
        return this.canRebase && this.canWrite && this.vetoes.isEmpty();
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    @Nonnull
    public Collection<PullRequestRebaseVeto> getVetoes() {
        return this.vetoes;
    }

    public static class Builder {
        private final ImmutableList.Builder<PullRequestRebaseVeto> vetoes = ImmutableList.builder();
        private boolean canRebase;
        private boolean canWrite;

        @Nonnull
        public SimplePullRequestRebaseability build() {
            return new SimplePullRequestRebaseability(this);
        }

        @Nonnull
        public Builder canRebase(boolean value) {
            this.canRebase = value;
            return this;
        }

        @Nonnull
        public Builder canWrite(boolean value) {
            this.canWrite = value;
            return this;
        }

        @Nonnull
        public Builder veto(@Nonnull PullRequestRebaseVeto veto) {
            this.vetoes.add((Object)Objects.requireNonNull(veto, "veto"));
            return this;
        }
    }
}

