/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.submodule;

import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.scm.ScmProtocolModuleDescriptor;
import com.atlassian.bitbucket.scm.http.RepositoryUrlFragment;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.scm.git.submodule.GitSubmoduleUriHandler;
import com.atlassian.stash.internal.scm.git.submodule.SubmoduleUrls;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class DefaultGitSubmoduleUriHandler
implements GitSubmoduleUriHandler {
    private final NavBuilder navBuilder;
    private final PluginAccessor pluginAccessor;

    public DefaultGitSubmoduleUriHandler(NavBuilder navBuilder, PluginAccessor pluginAccessor) {
        this.navBuilder = navBuilder;
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    @Nonnull
    public SubmoduleUrls process(@Nonnull URI scmUri, @Nonnull String contentId) {
        return this.getRepoUrlFragment(scmUri).map(fragment -> this.buildWebUrls((RepositoryUrlFragment)fragment, contentId)).orElse(SubmoduleUrls.NONE);
    }

    private SubmoduleUrls buildWebUrls(RepositoryUrlFragment fragment, String contentId) {
        NavBuilder.Repo repoBuilder = this.navBuilder.project(fragment.getProjectKey()).repo(fragment.getRepositorySlug());
        return new SubmoduleUrls(repoBuilder.buildAbsolute(), repoBuilder.browse().atRevision(contentId).buildAbsolute());
    }

    private Optional<RepositoryUrlFragment> getRepoUrlFragment(URI scmUri) {
        return ModuleDescriptorUtils.toModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(ScmProtocolModuleDescriptor.class)).filter(protocol -> protocol.supports("git")).map(protocol -> URI.create(protocol.getBaseUrl())).filter(baseUrl -> this.isUnderBaseUrl((URI)baseUrl, scmUri)).map(baseUrl -> this.makeFragment((URI)baseUrl, scmUri)).filter(Objects::nonNull).findFirst();
    }

    private RepositoryUrlFragment makeFragment(URI baseUrl, URI uri) {
        return RepositoryUrlFragment.fromPathInfo((String)uri.getPath().substring(StringUtils.removeEnd((String)baseUrl.getPath(), (String)"/").length()));
    }

    private boolean isUnderBaseUrl(URI baseUrl, URI uri) {
        return baseUrl.getHost().equals(uri.getHost()) && uri.getPort() == baseUrl.getPort() && uri.getPath().startsWith(baseUrl.getPath());
    }
}

