/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.submodule;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryCloneLinksRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.util.NamedLink;
import com.atlassian.stash.internal.scm.git.submodule.GitSubmoduleUriHandler;
import com.atlassian.stash.internal.scm.git.submodule.SubmoduleUrlBuilder;
import com.atlassian.stash.internal.scm.git.submodule.SubmoduleUrls;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class DefaultSubmoduleUrlBuilder
implements SubmoduleUrlBuilder {
    private static final GitSubmoduleUriHandler BITBUCKET = new GitSubmoduleUriHandler(){

        @Override
        @Nonnull
        public SubmoduleUrls process(@Nonnull URI uri, @Nonnull String contentId) {
            return DefaultSubmoduleUrlBuilder.fromUri(uri, "https://bitbucket.org", "/changeset/" + contentId + "/");
        }
    };
    private static final GitSubmoduleUriHandler GITHUB = new GitSubmoduleUriHandler(){

        @Override
        @Nonnull
        public SubmoduleUrls process(@Nonnull URI uri, @Nonnull String contentId) {
            return DefaultSubmoduleUrlBuilder.fromUri(uri, "https://github.com", "/tree/" + contentId);
        }
    };
    private static final GitSubmoduleUriHandler GITLAB = new GitSubmoduleUriHandler(){

        @Override
        @Nonnull
        public SubmoduleUrls process(@Nonnull URI uri, @Nonnull String contentId) {
            return DefaultSubmoduleUrlBuilder.fromUri(uri, "https://gitlab.com", "/-/tree/" + contentId);
        }
    };
    private static final Map<String, GitSubmoduleUriHandler> URI_HANDLERS = ImmutableMap.of((Object)"bitbucket.org", (Object)BITBUCKET, (Object)"github.com", (Object)GITHUB, (Object)"gitlab.com", (Object)GITLAB);
    private final GitSubmoduleUriHandler defaultUriHandler;
    private final RepositoryService repositoryService;

    public DefaultSubmoduleUrlBuilder(GitSubmoduleUriHandler defaultUriHandler, RepositoryService repositoryService) {
        this.defaultUriHandler = defaultUriHandler;
        this.repositoryService = repositoryService;
    }

    @Nonnull
    public SubmoduleUrls build(@Nonnull Repository repository, @Nonnull String url, @Nonnull String contentId) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(url, "url");
        Objects.requireNonNull(contentId, "contentId");
        try {
            URI uri = this.createUri(repository, url);
            return URI_HANDLERS.getOrDefault(uri.getHost(), this.defaultUriHandler).process(uri, contentId);
        }
        catch (URISyntaxException e) {
            return SubmoduleUrls.NONE;
        }
    }

    private static SubmoduleUrls fromUri(URI uri, String prefix, String postfix) {
        String url = prefix + StringUtils.removeEnd((String)uri.getPath(), (String)".git");
        return new SubmoduleUrls(url, url + postfix);
    }

    private static String maybeAddProtocol(String url) {
        if (url.contains("://") || !url.contains("@")) {
            return url;
        }
        return "ssh://" + StringUtils.replaceOnce((String)url, (String)":", (String)"/");
    }

    private URI createUri(Repository repository, String url) throws URISyntaxException {
        Set cloneLinks;
        NamedLink link;
        if ((url.startsWith("../") || url.startsWith("./")) && (link = (NamedLink)Iterables.getFirst((Iterable)(cloneLinks = this.repositoryService.getCloneLinks(new RepositoryCloneLinksRequest.Builder().protocol("http").repository(repository).build())), null)) != null) {
            return new URI(link.getHref() + "/").resolve(url);
        }
        return new URI(DefaultSubmoduleUrlBuilder.maybeAddProtocol(url));
    }
}

