/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.transcode;

import com.atlassian.bitbucket.mesh.rpc.v1.RpcSetTranscodeEnabledRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.scm.git.mesh.RpcRepositoryClient;
import com.atlassian.stash.internal.scm.git.transcode.GitTranscodeDiffSettingsChangedEvent;
import com.atlassian.stash.internal.scm.git.transcode.TranscodeService;
import jakarta.annotation.Nonnull;

public class MeshTranscodeService
implements TranscodeService {
    private final EventPublisher eventPublisher;
    private final RpcRepositoryClient repositoryClient;

    public MeshTranscodeService(EventPublisher eventPublisher, RpcRepositoryClient repositoryClient) {
        this.eventPublisher = eventPublisher;
        this.repositoryClient = repositoryClient;
    }

    @Override
    public boolean isEnabled(@Nonnull Repository repository) {
        return this.repositoryClient.isTranscodeEnabled(repository);
    }

    @Override
    public void setEnabled(@Nonnull Repository repository, boolean enabled) {
        boolean wasEnabled = this.isEnabled(repository);
        this.repositoryClient.setTranscodeEnabled(repository, RpcSetTranscodeEnabledRequest.newBuilder().setEnabled(enabled));
        if (enabled != wasEnabled) {
            this.eventPublisher.publish((Object)new GitTranscodeDiffSettingsChangedEvent(this, repository, enabled));
        }
    }
}

