/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.ui;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.ui.ContextualFormFragment;
import com.atlassian.bitbucket.ui.ValidationErrors;
import com.atlassian.bitbucket.view.TemplateRenderingException;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.stash.internal.scm.git.transcode.TranscodeService;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class TranscodeDiffsFormFragment
implements ContextualFormFragment {
    private static final String FRAGMENT_TEMPLATE = "bitbucket.internal.feature.git.transcodeSettings.enable";
    private static final String RESOURCE_KEY = "com.atlassian.bitbucket.server.bitbucket-git:transcode-settings";
    private static final String FIELD_KEY = "git-enable-transcoding";
    private static final String SOY_PARAM_ENABLED = "enabled";
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final TranscodeService transcodeService;

    public TranscodeDiffsFormFragment(SoyTemplateRenderer soyTemplateRenderer, TranscodeService transcodeService) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.transcodeService = transcodeService;
    }

    public void doError(@Nonnull Appendable appendable, @Nonnull Map<String, String[]> requestParams, @Nonnull Map<String, Collection<String>> fieldErrors, @Nonnull Map<String, Object> context) {
        Objects.requireNonNull(appendable, "appendable");
        Objects.requireNonNull(requestParams, "requestParams");
        Objects.requireNonNull(context, "context");
        context.put(SOY_PARAM_ENABLED, this.isCheckBoxEnabled(requestParams));
        this.renderView(appendable, context);
    }

    public void doView(@Nonnull Appendable appendable, @Nonnull Map<String, Object> context) throws IOException {
        Objects.requireNonNull(appendable, "appendable");
        Objects.requireNonNull(context, "context");
        Repository repository = (Repository)context.get("repository");
        context.put(SOY_PARAM_ENABLED, this.transcodeService.isEnabled(repository));
        this.renderView(appendable, context);
    }

    public void execute(@Nonnull Map<String, String[]> requestParams, @Nonnull Map<String, Object> context) {
        Objects.requireNonNull(requestParams, "requestParams");
        Objects.requireNonNull(context, "context");
        Repository repository = (Repository)context.get("repository");
        this.transcodeService.setEnabled(repository, this.isCheckBoxEnabled(requestParams));
    }

    public void validate(@Nonnull Map<String, String[]> requestParams, @Nonnull ValidationErrors errors, @Nonnull Map<String, Object> context) {
    }

    private boolean isCheckBoxEnabled(Map<String, String[]> requestParams) {
        String[] values = requestParams.get(FIELD_KEY);
        return values != null && values.length == 1 && values[0].equalsIgnoreCase("on");
    }

    private void renderView(Appendable appendable, Map<String, Object> context) {
        try {
            this.soyTemplateRenderer.render(appendable, RESOURCE_KEY, FRAGMENT_TEMPLATE, context);
        }
        catch (SoyException e) {
            throw new TemplateRenderingException("Failed to render bitbucket.internal.feature.git.transcodeSettings.enable", (Throwable)e);
        }
    }
}

