/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.util;

import com.atlassian.stash.internal.scm.git.InternalGitConstants;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlternatesUtils {
    private static final Pattern PATTERN_PATH = Pattern.compile(".+[/\\\\](\\d+)[/\\\\]objects");
    private static final String ALTERNATES_FILE_PATH = String.join((CharSequence)FileSystems.getDefault().getSeparator(), InternalGitConstants.SUBPATH_ALTERNATES);
    private static final Logger log = LoggerFactory.getLogger(AlternatesUtils.class);

    private AlternatesUtils() {
    }

    public static int getAlternateRepositoryId(@Nonnull String alternate) {
        Matcher matcher = PATTERN_PATH.matcher(alternate);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        log.error("Invalid alternate entry: {}", (Object)alternate);
        throw new IllegalArgumentException("Invalid alternate entry");
    }

    @Nonnull
    public static List<String> getAlternates(@Nonnull Path repositoryDir) throws IOException {
        Optional<Path> alternatesFile = AlternatesUtils.getAlternatesFile(repositoryDir);
        if (!alternatesFile.isPresent()) {
            log.debug("Repository with path '{}' doesn't have any alternates.", (Object)repositoryDir.toAbsolutePath());
            return ImmutableList.of();
        }
        return Files.readAllLines(alternatesFile.get(), StandardCharsets.UTF_8);
    }

    @Nonnull
    public static Optional<Path> getAlternatesFile(@Nonnull Path repositoryDir) {
        Objects.requireNonNull(repositoryDir, "repositoryDir");
        Preconditions.checkArgument((boolean)Files.isDirectory(repositoryDir, new LinkOption[0]), (Object)"'repositoryDir' is not a directory.");
        Path alternatesFile = repositoryDir.resolve(ALTERNATES_FILE_PATH);
        return Files.isRegularFile(alternatesFile, new LinkOption[0]) ? Optional.of(alternatesFile) : Optional.empty();
    }

    public static boolean hasAlternates(@Nonnull Path repositoryDir) {
        Objects.requireNonNull(repositoryDir, "repositoryDir");
        return AlternatesUtils.getAlternatesFile(repositoryDir).isPresent();
    }
}

