/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class AuditUtils {
    public static final String AUDIT_RESOURCE_TYPE_APPLINK = "APPLINK";
    public static final String AUDIT_RESOURCE_TYPE_COMMIT = "COMMIT";
    public static final String AUDIT_RESOURCE_TYPE_GROUP = "GROUP";
    public static final String AUDIT_RESOURCE_TYPE_MISC = "MISC";
    public static final String AUDIT_RESOURCE_TYPE_PROJECT = "PROJECT";
    public static final String AUDIT_RESOURCE_TYPE_PULL_REQUEST = "PULL_REQUEST";
    public static final String AUDIT_RESOURCE_TYPE_REPOSITORY = "REPOSITORY";
    public static final String AUDIT_RESOURCE_TYPE_USER = "USER";
    private static final ObjectMapper objectMapperInstance = new ObjectMapper();

    private AuditUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    @Nonnull
    public static AuditAuthor auditAuthorForUser(@Nonnull ApplicationUser user) {
        Objects.requireNonNull(user, "user");
        return new AuditAuthor.Builder().id(String.valueOf(user.getId())).name(user.getName()).type(user.getType().name()).build();
    }

    @Nonnull
    public static AuditResource auditResourceForAppLink(@Nonnull ApplicationLink applicationLink) {
        Objects.requireNonNull(applicationLink, "applicationLink");
        return AuditResource.builder((String)((String)StringUtils.firstNonEmpty((CharSequence[])new String[]{applicationLink.getName(), applicationLink.getId().get()})), (String)AUDIT_RESOURCE_TYPE_APPLINK).id(applicationLink.getId().get()).build();
    }

    public static AuditResource auditResourceForCommit(@Nonnull Repository repository, @Nonnull String commitId) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(commitId, "commitId");
        String shortCommidId = commitId.substring(0, 11);
        return AuditResource.builder((String)shortCommidId, (String)AUDIT_RESOURCE_TYPE_COMMIT).id(AuditUtils.commitResourceId(repository, commitId)).build();
    }

    @Nonnull
    public static AuditResource auditResourceForGroup(@Nonnull String group) {
        Objects.requireNonNull(group, "group");
        return AuditResource.builder((String)group, (String)AUDIT_RESOURCE_TYPE_GROUP).id(group).build();
    }

    @Nonnull
    public static AuditResource auditResourceForProject(@Nonnull Project project) {
        Objects.requireNonNull(project, "project");
        return AuditResource.builder((String)project.getKey(), (String)AUDIT_RESOURCE_TYPE_PROJECT).id(String.valueOf(project.getId())).build();
    }

    @Nonnull
    public static AuditResource auditResourceForPullRequest(@Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        return AuditResource.builder((String)("PR#" + pullRequest.getId()), (String)AUDIT_RESOURCE_TYPE_PULL_REQUEST).id(AuditUtils.pullRequestResourceId(pullRequest.getToRef().getRepository().getId(), pullRequest.getId())).build();
    }

    @Nonnull
    public static AuditResource auditResourceForRepository(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        return AuditResource.builder((String)repository.getSlug(), (String)AUDIT_RESOURCE_TYPE_REPOSITORY).id(String.valueOf(repository.getId())).build();
    }

    @Nonnull
    public static AuditResource auditResourceForUser(@Nonnull ApplicationUser user) {
        Objects.requireNonNull(user, "user");
        return AuditResource.builder((String)user.getName(), (String)AUDIT_RESOURCE_TYPE_USER).id(String.valueOf(user.getId())).build();
    }

    @Nonnull
    public static List<AuditResource> auditResourcesForProjectAndRepository(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        return ImmutableList.of((Object)AuditUtils.auditResourceForProject(repository.getProject()), (Object)AuditUtils.auditResourceForRepository(repository));
    }

    @Nonnull
    public static List<AuditResource> auditResourcesForProjectRepositoryPullRequest(@Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Repository repository = pullRequest.getToRef().getRepository();
        return ImmutableList.of((Object)AuditUtils.auditResourceForPullRequest(pullRequest), (Object)AuditUtils.auditResourceForRepository(repository), (Object)AuditUtils.auditResourceForProject(repository.getProject()));
    }

    @Nonnull
    public static AuditResource miscellaneousAuditResource(@Nonnull String name) {
        return AuditResource.builder((String)Objects.requireNonNull(name, "name"), (String)AUDIT_RESOURCE_TYPE_MISC).build();
    }

    public static String toJson(@Nullable Object value) {
        try {
            return AuditUtils.toJsonInternal(value);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to convert object %s to JSON", value), e);
        }
    }

    public static String toProjectAndRepositoryString(@Nullable Repository repository) {
        if (repository == null) {
            return null;
        }
        return repository.getProject().getKey() + "/" + repository.getSlug();
    }

    private static String commitResourceId(@Nonnull Repository repository, @Nonnull String commitId) {
        return repository.getId() + ":" + commitId;
    }

    private static String pullRequestResourceId(int repositoryId, Long pullRequestId) {
        return repositoryId + ":" + pullRequestId;
    }

    private static String toJsonInternal(Object value) throws IOException {
        return objectMapperInstance.writeValueAsString(value);
    }
}

