/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.util.UrlUtils;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;

public class ContentDispositionUtils {
    private static final String CREATION_DATE_HEADER = "; creation-date=";
    private static final String FILENAME_HEADER = "; filename=";
    private static final String UTF8_FILENAME_HEADER = "; filename*=UTF-8''";

    private ContentDispositionUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static String buildHeaderValue(@Nonnull DispositionType dispositionType, @Nonnull String filename) {
        Objects.requireNonNull(dispositionType, "dispositionType");
        Objects.requireNonNull(filename, "filename");
        return dispositionType.name().toLowerCase(Locale.ROOT) + "; filename=\"" + ContentDispositionUtils.replaceNonAscii(filename) + "\"; filename*=UTF-8''" + UrlUtils.encodeURL(filename);
    }

    public static String buildHeaderValue(@Nonnull DispositionType dispositionType, @Nonnull String filename, @Nonnull Instant creationDate) {
        Objects.requireNonNull(creationDate, "creationDate");
        return ContentDispositionUtils.buildHeaderValue(dispositionType, filename) + "; creation-date=\"" + ContentDispositionUtils.formatDate(creationDate) + "\"";
    }

    private static String formatDate(Instant creationDate) {
        return DateTimeFormatter.RFC_1123_DATE_TIME.format(creationDate.atOffset(ZoneOffset.UTC));
    }

    private static String replaceNonAscii(String str) {
        return str.replaceAll("[^\\p{ASCII}]", "_");
    }

    public static enum DispositionType {
        ATTACHMENT,
        INLINE;


        public static DispositionType fromString(String str) {
            return DispositionType.valueOf(str.toUpperCase(Locale.ROOT));
        }
    }
}

