/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Objects;

public class PathMatchers {
    private PathMatchers() {
        throw new UnsupportedOperationException("Cannot be initialised.");
    }

    @Nonnull
    public static CombinablePathMatcher.BothPathMatcher both(@Nonnull PathMatcher matcher) {
        return new CombinablePathMatcher.BothPathMatcher(matcher);
    }

    @Nonnull
    public static CombinablePathMatcher.EitherPathMatcher either(@Nonnull PathMatcher matcher) {
        return new CombinablePathMatcher.EitherPathMatcher(matcher);
    }

    @Nonnull
    public static PathMatcher not(@Nonnull PathMatcher matcher) {
        Objects.requireNonNull(matcher, "matcher");
        return path -> !matcher.matches(path);
    }

    public static class CombinablePathMatcher
    implements PathMatcher {
        private final PathMatcher first;

        public CombinablePathMatcher(@Nonnull PathMatcher first) {
            this.first = Objects.requireNonNull(first, "first");
        }

        @Nonnull
        public CombinablePathMatcher and(@Nonnull PathMatcher other) {
            return new CombinablePathMatcher(path -> this.matches(path) && other.matches(path));
        }

        @Override
        public boolean matches(Path path) {
            return this.first.matches(path);
        }

        @Nonnull
        public CombinablePathMatcher or(@Nonnull PathMatcher other) {
            return new CombinablePathMatcher(path -> this.matches(path) || other.matches(path));
        }

        public static final class EitherPathMatcher {
            private final PathMatcher first;

            public EitherPathMatcher(@Nonnull PathMatcher first) {
                this.first = Objects.requireNonNull(first, "first");
            }

            @Nonnull
            public CombinablePathMatcher or(@Nonnull PathMatcher other) {
                return new CombinablePathMatcher(this.first).or(other);
            }
        }

        public static final class BothPathMatcher {
            private final PathMatcher first;

            public BothPathMatcher(@Nonnull PathMatcher first) {
                this.first = Objects.requireNonNull(first, "first");
            }

            @Nonnull
            public CombinablePathMatcher and(@Nonnull PathMatcher other) {
                return new CombinablePathMatcher(this.first).and(other);
            }
        }
    }
}

