/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;

public class PropertiesUtils {
    private PropertiesUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    @Nonnull
    public static Properties load(@Nonnull Path path) throws IOException {
        Objects.requireNonNull(path, "path");
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            Properties properties = new Properties();
            properties.load(reader);
            Properties properties2 = properties;
            return properties2;
        }
    }

    @Nonnull
    public static Optional<Properties> loadIfPresent(@Nonnull Path path) throws IOException {
        try {
            return Optional.of(PropertiesUtils.load(path));
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return Optional.empty();
        }
    }

    public static void store(@Nonnull Properties properties, @Nonnull Path path) throws IOException {
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(path, "path");
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            properties.store(writer, null);
        }
    }
}

