/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.request.RequestLocal;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.cache.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public class RequestLocalSoftCache<K, V> {
    private final RequestLocal<Cache<K, Optional<V>>> cache;

    public RequestLocalSoftCache(@Nonnull RequestManager requestManager) {
        this.cache = Objects.requireNonNull(requestManager, "requestManager").newRequestLocal();
    }

    public V get(@Nonnull K key, @Nonnull Supplier<V> loader) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(loader, "loader");
        if (this.cache.isActive()) {
            try {
                return ((Optional)((Cache)this.cache.computeIfAbsent(this::createCache)).get(key, () -> Optional.ofNullable(loader.get()))).orElse(null);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return (V)loader.get();
    }

    private Cache<K, Optional<V>> createCache() {
        return CacheBuilder.newBuilder().softValues().build();
    }
}

